/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.server;

import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.impl.hadoop.HDFSFile;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.server.ServerConnectDialog;
import com.mucommander.ui.dialog.server.ServerPanel;
import com.mucommander.ui.main.MainFrame;
import java.net.MalformedURLException;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class HDFSPanel
extends ServerPanel {
    private JTextField serverField = new JTextField(lastServer);
    private JTextField usernameField;
    private JTextField initialDirField;
    private JSpinner portSpinner;
    private static String lastServer = "";
    private static String lastUsername = HDFSFile.getDefaultUsername();
    private static String lastInitialDir = "/";
    private static int lastPort = FileURL.getRegisteredHandler("hdfs").getStandardPort();

    HDFSPanel(ServerConnectDialog dialog, MainFrame mainFrame) {
        super(dialog, mainFrame);
        this.serverField.selectAll();
        this.addTextFieldListeners(this.serverField, true);
        this.addRow(Translator.get("server_connect_dialog.server", new String[0]), (JComponent)this.serverField, 15);
        this.usernameField = new JTextField(lastUsername);
        this.usernameField.selectAll();
        this.addTextFieldListeners(this.usernameField, false);
        this.addRow(Translator.get("server_connect_dialog.username", new String[0]), (JComponent)this.usernameField, 15);
        this.initialDirField = new JTextField(lastInitialDir);
        this.initialDirField.selectAll();
        this.addTextFieldListeners(this.initialDirField, true);
        this.addRow(Translator.get("server_connect_dialog.initial_dir", new String[0]), (JComponent)this.initialDirField, 5);
        this.portSpinner = this.createPortSpinner(lastPort);
        this.addRow(Translator.get("server_connect_dialog.port", new String[0]), (JComponent)this.portSpinner, 15);
    }

    private void updateValues() {
        lastServer = this.serverField.getText();
        lastUsername = this.usernameField.getText();
        lastInitialDir = this.initialDirField.getText();
        lastPort = (Integer)this.portSpinner.getValue();
    }

    FileURL getServerURL() throws MalformedURLException {
        this.updateValues();
        if (!lastInitialDir.startsWith("/")) {
            lastInitialDir = "/" + lastInitialDir;
        }
        FileURL url = FileURL.getFileURL("hdfs://" + lastServer + lastInitialDir);
        url.setCredentials(new Credentials(lastUsername, ""));
        url.setPort(lastPort);
        return url;
    }

    boolean usesCredentials() {
        return true;
    }

    public void dialogValidated() {
        try {
            this.portSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.updateValues();
    }
}

