/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.server;

import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.server.ServerConnectDialog;
import com.mucommander.ui.dialog.server.ServerPanel;
import com.mucommander.ui.main.MainFrame;
import java.net.MalformedURLException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class HTTPPanel
extends ServerPanel {
    private JTextField urlField = new JTextField(lastURL);
    private JTextField usernameField;
    private JPasswordField passwordField;
    private static String lastURL = "http://";
    private static String lastUsername = "";
    private String lastPassword = "";

    HTTPPanel(ServerConnectDialog dialog, MainFrame mainFrame) {
        super(dialog, mainFrame);
        this.urlField.selectAll();
        this.addTextFieldListeners(this.urlField, true);
        this.addRow(Translator.get("server_connect_dialog.http_url", new String[0]), (JComponent)this.urlField, 20);
        this.addRow(new JLabel(Translator.get("http_connect.basic_authentication", new String[0])), 10);
        this.usernameField = new JTextField(lastUsername);
        this.usernameField.selectAll();
        this.addTextFieldListeners(this.usernameField, false);
        this.addRow(Translator.get("server_connect_dialog.username", new String[0]), (JComponent)this.usernameField, 5);
        this.passwordField = new JPasswordField(this.lastPassword);
        this.addTextFieldListeners(this.passwordField, false);
        this.addRow(Translator.get("password", new String[0]), (JComponent)this.passwordField, 0);
    }

    private void updateValues() {
        lastURL = this.urlField.getText();
        lastUsername = this.usernameField.getText();
        this.lastPassword = new String(this.passwordField.getPassword());
    }

    FileURL getServerURL() throws MalformedURLException {
        this.updateValues();
        if (!lastURL.toLowerCase().startsWith("http://") && !lastURL.toLowerCase().startsWith("https://")) {
            lastURL = "http://" + lastURL;
        }
        FileURL fileURL = FileURL.getFileURL(lastURL);
        fileURL.setCredentials(new Credentials(lastUsername, this.lastPassword));
        return fileURL;
    }

    boolean usesCredentials() {
        return true;
    }

    public void dialogValidated() {
        this.updateValues();
    }
}

