/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.server;

import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.server.ServerConnectDialog;
import com.mucommander.ui.dialog.server.ServerPanel;
import com.mucommander.ui.main.MainFrame;
import java.net.MalformedURLException;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class S3Panel
extends ServerPanel {
    private JTextField serverField = new JTextField(lastServer);
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JTextField initialDirField;
    private JSpinner portSpinner;
    private static String lastServer = "s3.amazonaws.com";
    private static String lastUsername = "";
    private String lastPassword = "";
    private static String lastInitialDir = "/";
    private static int lastPort = FileURL.getRegisteredHandler("s3").getStandardPort();

    S3Panel(ServerConnectDialog dialog, MainFrame mainFrame) {
        super(dialog, mainFrame);
        this.serverField.selectAll();
        this.addTextFieldListeners(this.serverField, true);
        this.addRow(Translator.get("server_connect_dialog.server", new String[0]), (JComponent)this.serverField, 15);
        this.usernameField = new JTextField(lastUsername);
        this.usernameField.selectAll();
        this.addTextFieldListeners(this.usernameField, false);
        this.addRow("Access ID Key", (JComponent)this.usernameField, 5);
        this.passwordField = new JPasswordField();
        this.addTextFieldListeners(this.passwordField, false);
        this.addRow("Secret Access Key", (JComponent)this.passwordField, 15);
        this.initialDirField = new JTextField(lastInitialDir);
        this.initialDirField.selectAll();
        this.addTextFieldListeners(this.initialDirField, true);
        this.addRow(Translator.get("server_connect_dialog.initial_dir", new String[0]), (JComponent)this.initialDirField, 5);
        this.portSpinner = this.createPortSpinner(lastPort);
        this.addRow(Translator.get("server_connect_dialog.port", new String[0]), (JComponent)this.portSpinner, 15);
    }

    private void updateValues() {
        lastServer = this.serverField.getText();
        lastUsername = this.usernameField.getText();
        this.lastPassword = new String(this.passwordField.getPassword());
        lastInitialDir = this.initialDirField.getText();
        lastPort = (Integer)this.portSpinner.getValue();
    }

    FileURL getServerURL() throws MalformedURLException {
        this.updateValues();
        if (!lastInitialDir.startsWith("/")) {
            lastInitialDir = "/" + lastInitialDir;
        }
        FileURL url = FileURL.getFileURL("s3://" + lastServer + lastInitialDir);
        url.setCredentials(new Credentials(lastUsername, this.lastPassword));
        url.setPort(lastPort);
        return url;
    }

    boolean usesCredentials() {
        return true;
    }

    public void dialogValidated() {
        try {
            this.portSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.updateValues();
    }
}

