/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.server;

import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.server.ServerConnectDialog;
import com.mucommander.ui.dialog.server.ServerPanel;
import com.mucommander.ui.main.MainFrame;
import java.net.MalformedURLException;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class SMBPanel
extends ServerPanel {
    private JTextField domainField;
    private JTextField serverField = new JTextField(lastServer);
    private JTextField shareField;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private static String lastDomain = "";
    private static String lastServer = "";
    private static String lastShare = "";
    private static String lastUsername = "";
    private String lastPassword = "";

    SMBPanel(ServerConnectDialog dialog, MainFrame mainFrame) {
        super(dialog, mainFrame);
        this.serverField.selectAll();
        this.addTextFieldListeners(this.serverField, true);
        this.addRow(Translator.get("server_connect_dialog.server", new String[0]), (JComponent)this.serverField, 5);
        this.shareField = new JTextField(lastShare);
        this.shareField.selectAll();
        this.addTextFieldListeners(this.shareField, true);
        this.addRow(Translator.get("server_connect_dialog.share", new String[0]), (JComponent)this.shareField, 15);
        this.domainField = new JTextField(lastDomain);
        this.domainField.selectAll();
        this.addTextFieldListeners(this.domainField, true);
        this.addRow(Translator.get("server_connect_dialog.domain", new String[0]), (JComponent)this.domainField, 15);
        this.usernameField = new JTextField(lastUsername);
        this.usernameField.selectAll();
        this.addTextFieldListeners(this.usernameField, false);
        this.addRow(Translator.get("server_connect_dialog.username", new String[0]), (JComponent)this.usernameField, 5);
        this.passwordField = new JPasswordField();
        this.addTextFieldListeners(this.passwordField, false);
        this.addRow(Translator.get("password", new String[0]), (JComponent)this.passwordField, 0);
    }

    private void updateValues() {
        lastServer = this.serverField.getText();
        lastShare = this.shareField.getText();
        lastDomain = this.domainField.getText();
        lastUsername = this.usernameField.getText();
        this.lastPassword = new String(this.passwordField.getPassword());
    }

    FileURL getServerURL() throws MalformedURLException {
        this.updateValues();
        FileURL url = FileURL.getFileURL("smb://" + lastServer + (lastShare.startsWith("/") ? "" : "/") + lastShare);
        String userInfo = lastUsername;
        if (!lastDomain.equals("")) {
            userInfo = lastDomain + ";" + userInfo;
        }
        url.setCredentials(new Credentials(userInfo, this.lastPassword));
        return url;
    }

    boolean usesCredentials() {
        return true;
    }

    public void dialogValidated() {
        this.updateValues();
    }
}

