/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.shell;

import com.mucommander.process.AbstractProcess;
import com.mucommander.process.ProcessListener;
import com.mucommander.shell.Shell;
import com.mucommander.shell.ShellHistoryManager;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.dialog.shell.ShellComboBox;
import com.mucommander.ui.icon.SpinningDial;
import com.mucommander.ui.layout.XBoxPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunDialog
extends FocusDialog
implements ProcessListener,
ActionListener,
KeyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunDialog.class);
    private MainFrame mainFrame;
    private ShellComboBox inputCombo;
    private JButton runStopButton;
    private JButton cancelButton;
    private JButton clearButton;
    private JTextArea outputTextArea;
    private SpinningDial dial;
    private PrintStream processInput;
    private AbstractProcess currentProcess;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(600, 400);

    private JScrollPane createOutputArea() {
        this.outputTextArea = new JTextArea();
        this.outputTextArea.setLineWrap(true);
        this.outputTextArea.setCaretPosition(0);
        this.outputTextArea.setRows(10);
        this.outputTextArea.setEditable(false);
        this.outputTextArea.addKeyListener(this);
        this.outputTextArea.setForeground(ThemeManager.getCurrentColor(33));
        this.outputTextArea.setCaretColor(ThemeManager.getCurrentColor(33));
        this.outputTextArea.setBackground(ThemeManager.getCurrentColor(34));
        this.outputTextArea.setSelectedTextColor(ThemeManager.getCurrentColor(35));
        this.outputTextArea.setSelectionColor(ThemeManager.getCurrentColor(36));
        this.outputTextArea.setFont(ThemeManager.getCurrentFont(1));
        return new JScrollPane(this.outputTextArea, 20, 30);
    }

    private YBoxPanel createInputArea() {
        YBoxPanel mainPanel = new YBoxPanel();
        mainPanel.add(new JLabel(this.mainFrame.getActiveTable().getCurrentFolder().getURL().getScheme().equals("file") ? Translator.get("run_dialog.run_command_description", new String[0]) + ":" : Translator.get("run_dialog.run_in_home_description", new String[0]) + ":"));
        this.inputCombo = new ShellComboBox(this);
        mainPanel.add(this.inputCombo);
        this.inputCombo.setEnabled(true);
        mainPanel.addSpace(10);
        JPanel labelPanel = new JPanel(new FlowLayout(0));
        labelPanel.add(new JLabel(Translator.get("run_dialog.command_output", new String[0]) + ":"));
        this.dial = new SpinningDial();
        labelPanel.add(new JLabel(this.dial));
        mainPanel.add(labelPanel);
        return mainPanel;
    }

    private XBoxPanel createButtonsArea() {
        XBoxPanel buttonsPanel = new XBoxPanel();
        this.clearButton = new JButton(Translator.get("run_dialog.clear_history", new String[0]));
        buttonsPanel.add(this.clearButton);
        this.clearButton.addActionListener(this);
        buttonsPanel.add(Box.createHorizontalGlue());
        this.runStopButton = new JButton(Translator.get("run_dialog.run", new String[0]));
        this.cancelButton = new JButton(Translator.get("cancel", new String[0]));
        buttonsPanel.add(DialogToolkit.createOKCancelPanel(this.runStopButton, this.cancelButton, this.getRootPane(), this));
        return buttonsPanel;
    }

    public RunDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, ActionProperties.getActionLabel("RunCommand"), (Component)mainFrame);
        this.mainFrame = mainFrame;
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.createInputArea(), "North");
        contentPane.add((Component)this.createOutputArea(), "Center");
        contentPane.add((Component)this.createButtonsArea(), "South");
        this.setInitialFocusComponent(this.inputCombo);
        this.getRootPane().setDefaultButton(this.runStopButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                if (RunDialog.this.currentProcess != null) {
                    RunDialog.this.processInput.close();
                    RunDialog.this.currentProcess.destroy();
                }
            }
        });
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
    }

    public void processDied(int retValue) {
        LOGGER.debug("process exit, return value= " + retValue);
        this.currentProcess = null;
        if (this.processInput != null) {
            this.processInput.close();
            this.processInput = null;
        }
        this.switchToRunState();
    }

    public void processOutput(byte[] buffer, int offset, int length) {
    }

    public void processOutput(String output) {
        this.addToTextArea(output);
    }

    public void keyPressed(KeyEvent event) {
        if (this.currentProcess != null && event.getKeyCode() != 27) {
            char character = event.getKeyChar();
            if (character != '\uffff') {
                this.processInput.print(character);
                this.addToTextArea(String.valueOf(character));
            }
            event.consume();
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.clearButton) {
            ShellHistoryManager.clear();
            if (this.currentProcess == null) {
                this.inputCombo.requestFocus();
                this.outputTextArea.setText("");
            } else {
                this.outputTextArea.requestFocus();
                this.outputTextArea.getCaret().setVisible(true);
            }
        } else if (source == this.runStopButton) {
            if (this.currentProcess == null) {
                this.runCommand(this.inputCombo.getCommand());
            } else {
                this.processInput.close();
                this.currentProcess.destroy();
                this.currentProcess = null;
                this.switchToRunState();
            }
        } else if (source == this.cancelButton) {
            if (this.currentProcess != null) {
                this.currentProcess.destroy();
            }
            this.dispose();
        }
    }

    private void switchToRunState() {
        this.dial.setAnimated(false);
        this.runStopButton.setText(Translator.get("run_dialog.run", new String[0]));
        this.inputCombo.setEnabled(true);
        this.inputCombo.requestFocus();
        this.outputTextArea.getCaret().setVisible(false);
        this.repaint();
    }

    public void runCommand(String command) {
        try {
            this.dial.setAnimated(true);
            this.runStopButton.setText(Translator.get("run_dialog.stop", new String[0]));
            this.outputTextArea.setText("");
            this.outputTextArea.setCaretPosition(0);
            this.outputTextArea.getCaret().setVisible(true);
            this.outputTextArea.requestFocus();
            this.inputCombo.setEnabled(false);
            this.currentProcess = Shell.execute(command, this.mainFrame.getActiveTable().getCurrentFolder(), this);
            this.processInput = new PrintStream(this.currentProcess.getOutputStream(), true);
            this.repaint();
        }
        catch (Exception e) {
            this.addToTextArea(Translator.get("generic_error", new String[0]));
            this.switchToRunState();
        }
    }

    private void addToTextArea(String s) {
        this.outputTextArea.append(s);
        this.outputTextArea.setCaretPosition(this.outputTextArea.getText().length());
        this.outputTextArea.getCaret().setVisible(true);
        this.outputTextArea.repaint();
    }
}

