/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.startup;

import com.mucommander.VersionChecker;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.job.SelfUpdateJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.QuestionDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.layout.InformationPane;
import com.mucommander.ui.main.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.util.Vector;
import javax.swing.JCheckBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckVersionDialog
extends QuestionDialog
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckVersionDialog.class);
    private MainFrame mainFrame;
    private boolean userInitiated;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(320, 0);

    public CheckVersionDialog(MainFrame mainFrame, boolean userInitiated) {
        super((Frame)mainFrame, "", (Component)mainFrame);
        this.mainFrame = mainFrame;
        this.userInitiated = userInitiated;
        new Thread((Runnable)this, "com.mucommander.ui.dialog.startup.CheckVersionDialog's Thread").start();
    }

    public void run() {
        String message;
        String title;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        URL downloadURL = null;
        boolean downloadOption = false;
        String jarURL = null;
        try {
            LOGGER.debug("Checking for new version...");
            VersionChecker version = VersionChecker.getInstance();
            if (version.isNewVersionAvailable()) {
                LOGGER.info("A new version is available!");
                title = Translator.get("version_dialog.new_version_title", new String[0]);
                downloadURL = new URL(version.getDownloadURL());
                downloadOption = DesktopManager.isOperationSupported("browse", new Object[]{downloadURL});
                message = downloadOption ? Translator.get("version_dialog.new_version", new String[0]) : Translator.get("version_dialog.new_version_url", downloadURL.toString());
                jarURL = version.getJarURL();
            } else {
                LOGGER.debug("No new version.");
                if (!this.userInitiated) {
                    this.dispose();
                    return;
                }
                title = Translator.get("version_dialog.no_new_version_title", new String[0]);
                message = Translator.get("version_dialog.no_new_version", new String[0]);
            }
        }
        catch (Exception e) {
            if (!this.userInitiated) {
                this.dispose();
                return;
            }
            title = Translator.get("version_dialog.not_available_title", new String[0]);
            message = Translator.get("version_dialog.not_available", new String[0]);
        }
        this.setTitle(title);
        Vector<Integer> actionsV = new Vector<Integer>();
        Vector<String> labelsV = new Vector<String>();
        actionsV.add(0);
        labelsV.add(Translator.get("ok", new String[0]));
        if (downloadOption) {
            actionsV.add(1);
            labelsV.add(ActionProperties.getActionLabel("GoToWebsite"));
        }
        int nbChoices = actionsV.size();
        int[] actions = new int[nbChoices];
        String[] labels = new String[nbChoices];
        for (int i = 0; i < nbChoices; ++i) {
            actions[i] = (Integer)actionsV.get(i);
            labels[i] = (String)labelsV.get(i);
        }
        this.init(new InformationPane(message, null, 0, 2), labels, actions, 0);
        JCheckBox showNextTimeCheckBox = new JCheckBox(Translator.get("prefs_dialog.check_for_updates_on_startup", new String[0]), MuConfigurations.getPreferences().getVariable(MuPreference.CHECK_FOR_UPDATE, true));
        this.addComponent(showNextTimeCheckBox);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        int action = this.getActionValue();
        if (action == 1) {
            try {
                DesktopManager.executeOperation("browse", new Object[]{downloadURL});
            }
            catch (Exception e) {
                InformationDialog.showErrorDialog(this);
            }
        } else if (action == 2) {
            ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, Translator.get("Installing new version", new String[0]));
            SelfUpdateJob job = new SelfUpdateJob(progressDialog, this.mainFrame, FileFactory.getFile(jarURL));
            progressDialog.start(job);
        }
        MuConfigurations.getPreferences().setVariable(MuPreference.CHECK_FOR_UPDATE, showNextTimeCheckBox.isSelected());
    }
}

