/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.startup;

import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.theme.Theme;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class InitialSetupDialog
extends FocusDialog
implements ActionListener {
    private UIManager.LookAndFeelInfo[] lfInfo;
    private JComboBox themeComboBox;
    private JComboBox lfComboBox;
    private JButton okButton;

    private JPanel createThemePanel() {
        YBoxPanel themePanel = new YBoxPanel();
        themePanel.setAlignmentX(0.0f);
        themePanel.setBorder(BorderFactory.createTitledBorder(Translator.get("prefs_dialog.themes", new String[0])));
        JPanel tempPanel = new JPanel(new FlowLayout(0));
        tempPanel.add(new JLabel(Translator.get("setup.theme", new String[0]) + ':'));
        ((Container)themePanel).add(tempPanel);
        this.themeComboBox = new JComboBox();
        Iterator<Theme> themes = ThemeManager.availableThemes();
        int index = 0;
        int selectedIndex = 0;
        while (themes.hasNext()) {
            Theme theme = themes.next();
            this.themeComboBox.addItem(theme);
            if (ThemeManager.isCurrentTheme(theme)) {
                selectedIndex = index;
            }
            ++index;
        }
        this.themeComboBox.setSelectedIndex(selectedIndex);
        this.themeComboBox.addActionListener(this);
        ((Container)themePanel).add(this.themeComboBox);
        return themePanel;
    }

    private JPanel createLookAndFeelPanel() {
        YBoxPanel lfPanel = new YBoxPanel();
        lfPanel.setAlignmentX(0.0f);
        lfPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("prefs_dialog.look_and_feel", new String[0])));
        JPanel tempPanel = new JPanel(new FlowLayout(0));
        tempPanel.add(new JLabel(Translator.get("setup.look_and_feel", new String[0]) + ':'));
        ((Container)lfPanel).add(tempPanel);
        this.lfComboBox = new JComboBox();
        this.lfInfo = UIManager.getInstalledLookAndFeels();
        String currentLf = UIManager.getLookAndFeel().getName();
        int selectedIndex = -1;
        for (int i = 0; i < this.lfInfo.length; ++i) {
            String buffer = this.lfInfo[i].getName();
            if (currentLf.equals(buffer)) {
                selectedIndex = i;
            } else if (selectedIndex == -1 && (currentLf.startsWith(buffer) || buffer.startsWith(currentLf))) {
                selectedIndex = i;
            }
            this.lfComboBox.addItem(buffer);
        }
        if (selectedIndex == -1) {
            selectedIndex = 0;
        }
        this.lfComboBox.setSelectedIndex(selectedIndex);
        this.lfComboBox.addActionListener(this);
        ((Container)lfPanel).add(this.lfComboBox);
        return lfPanel;
    }

    private JPanel createMainPanel() {
        YBoxPanel mainPanel = new YBoxPanel();
        mainPanel.add(new JLabel(Translator.get("setup.intro", new String[0])));
        mainPanel.addSpace(10);
        mainPanel.add(this.createThemePanel());
        mainPanel.addSpace(10);
        mainPanel.add(this.createLookAndFeelPanel());
        mainPanel.addSpace(10);
        JPanel okPanel = new JPanel();
        okPanel.setLayout(new FlowLayout(4));
        this.okButton = new JButton(Translator.get("ok", new String[0]));
        okPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        mainPanel.add(okPanel);
        return mainPanel;
    }

    public InitialSetupDialog(Frame owner) {
        super(owner, Translator.get("setup.title", new String[0]), (Component)owner);
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.setResizable(false);
        this.setInitialFocusComponent(this.themeComboBox);
        this.setKeyboardDisposalEnabled(false);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.themeComboBox) {
            ThemeManager.setCurrentTheme((Theme)this.themeComboBox.getSelectedItem());
        } else if (e.getSource() == this.lfComboBox) {
            MuConfigurations.getPreferences().setVariable(MuPreference.LOOK_AND_FEEL, this.lfInfo[this.lfComboBox.getSelectedIndex()].getClassName());
        } else if (e.getSource() == this.okButton) {
            ThemeManager.setCurrentTheme((Theme)this.themeComboBox.getSelectedItem());
            MuConfigurations.getPreferences().setVariable(MuPreference.LOOK_AND_FEEL, this.lfInfo[this.lfComboBox.getSelectedIndex()].getClassName());
            this.dispose();
        }
    }
}

