/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dnd;

import com.mucommander.ui.dnd.ClipboardSupport;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import javax.swing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClipboardNotifier
implements FlavorListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClipboardNotifier.class);
    private Action action;

    public ClipboardNotifier(Action action) {
        this.action = action;
        this.toggleActionState();
        ClipboardSupport.getClipboard().addFlavorListener(this);
    }

    private void toggleActionState() {
        try {
            this.action.setEnabled(ClipboardSupport.getClipboard().isDataFlavorAvailable(DataFlavor.javaFileListFlavor));
        }
        catch (Exception e) {
            LOGGER.debug("Caught an exception while querying the clipboard for files", e);
        }
    }

    public void flavorsChanged(FlavorEvent event) {
        this.toggleActionState();
    }
}

