/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dnd;

import com.mucommander.commons.file.util.FileSet;
import com.mucommander.ui.dnd.TransferableFileSet;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;

public class ClipboardSupport {
    public static Transferable getClipboardContents() {
        try {
            return ClipboardSupport.getClipboard().getContents(null);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static void setClipboardContents(Transferable transferable) {
        try {
            ClipboardSupport.getClipboard().setContents(transferable, null);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static FileSet getClipboardFiles() {
        Transferable transferable = ClipboardSupport.getClipboardContents();
        if (transferable == null) {
            return null;
        }
        return TransferableFileSet.getTransferFiles(transferable);
    }

    public static void setClipboardFiles(FileSet fileSet) {
        TransferableFileSet tfs = new TransferableFileSet(fileSet);
        tfs.setFileSetDataFlavorSupported(false);
        ClipboardSupport.setClipboardContents(tfs);
    }

    public static Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }
}

