/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dnd;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.ui.dnd.DnDContext;
import com.mucommander.ui.dnd.TransferableFileSet;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.main.table.FileTableModel;
import java.awt.Component;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;

public class FileDragSourceListener
implements DragGestureListener,
DragSourceListener {
    private FolderPanel folderPanel;

    public FileDragSourceListener(FolderPanel folderPanel) {
        this.folderPanel = folderPanel;
    }

    public void enableDrag(Component c) {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(c, 0x40000003, this);
    }

    public void dragGestureRecognized(DragGestureEvent event) {
        FileSet markedFiles;
        if (this.folderPanel.getMainFrame().getNoEventsMode()) {
            return;
        }
        FileTable fileTable = this.folderPanel.getFileTable();
        FileTableModel tableModel = fileTable.getFileTableModel();
        if ((event.getTriggerEvent().getModifiers() & 0xC) != 0) {
            return;
        }
        int clickedRow = fileTable.rowAtPoint(event.getDragOrigin());
        if (clickedRow == -1 || fileTable.isParentFolder(clickedRow)) {
            return;
        }
        AbstractFile selectedFile = tableModel.getFileAtRow(clickedRow);
        FileSet draggedFiles = tableModel.getNbMarkedFiles() > 0 && (markedFiles = fileTable.getSelectedFiles()).contains(selectedFile) ? markedFiles : new FileSet(fileTable.getCurrentFolder(), selectedFile);
        DnDContext.setDragInitiatedByMucommander(true);
        DnDContext.setDragInitiator(this.folderPanel);
        DnDContext.setDragGestureModifiersEx(event.getTriggerEvent().getModifiersEx());
        DragSource.getDefaultDragSource().startDrag(event, null, new TransferableFileSet(draggedFiles), this);
    }

    public void dragEnter(DragSourceDragEvent event) {
        DnDContext.setDragGestureModifiersEx(event.getGestureModifiersEx());
    }

    public void dragOver(DragSourceDragEvent event) {
    }

    public void dropActionChanged(DragSourceDragEvent event) {
        DnDContext.setDragGestureModifiersEx(event.getGestureModifiersEx());
    }

    public void dragExit(DragSourceEvent event) {
    }

    public void dragDropEnd(DragSourceDropEvent event) {
        DnDContext.setDragInitiatedByMucommander(false);
        DnDContext.setDragInitiator(null);
        DnDContext.setDragGestureModifiersEx(0);
    }
}

