/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dnd;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.util.FileSet;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferableFileSet
implements Transferable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferableFileSet.class);
    private FileSet fileSet;
    private boolean fileSetFlavorSupported = true;
    private boolean javaFileListFlavorSupported = true;
    private boolean stringFlavorSupported = true;
    private boolean textUriFlavorSupported = true;
    private boolean stringFlavourTransfersFilename = false;
    private static DataFlavor TEXT_URI_FLAVOR;
    private static DataFlavor FILE_SET_DATA_FLAVOR;

    public TransferableFileSet(FileSet fileSet) {
        this.fileSet = fileSet;
    }

    public void setFileSetDataFlavorSupported(boolean supported) {
        this.fileSetFlavorSupported = supported;
    }

    public void setJavaFileListDataFlavorSupported(boolean supported) {
        this.javaFileListFlavorSupported = supported;
    }

    public void setTextUriFlavorSupported(boolean supported) {
        this.textUriFlavorSupported = supported;
    }

    public void setStringDataFlavourTransfersFilename(boolean b) {
        this.stringFlavourTransfersFilename = b;
    }

    public static DataFlavor getFileSetDataFlavor() {
        return FILE_SET_DATA_FLAVOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileSet getTransferFiles(Transferable transferable) {
        try {
            FileSet files;
            if (transferable.isDataFlavorSupported(FILE_SET_DATA_FLAVOR)) {
                return (FileSet)transferable.getTransferData(FILE_SET_DATA_FLAVOR);
            }
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                int nbFiles = fileList.size();
                files = new FileSet();
                int i = 0;
                while (i < nbFiles) {
                    AbstractFile file = FileFactory.getFile(((File)fileList.get(i)).getAbsolutePath());
                    if (file != null) {
                        files.add(file);
                    }
                    ++i;
                }
                return files;
            }
            if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) return null;
            BufferedReader br = null;
            try {
                String path;
                br = new BufferedReader(DataFlavor.getTextPlainUnicodeFlavor().getReaderForText(transferable));
                files = new FileSet();
                while ((path = br.readLine()) != null) {
                    AbstractFile file = FileFactory.getFile(path);
                    if (file == null) {
                        FileSet fileSet = null;
                        return fileSet;
                    }
                    files.add(file);
                }
                return files;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Caught exception while processing transferable", e);
            return null;
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        Vector<DataFlavor> supportedDataFlavorsV = new Vector<DataFlavor>();
        if (this.fileSetFlavorSupported) {
            supportedDataFlavorsV.add(FILE_SET_DATA_FLAVOR);
        }
        if (this.javaFileListFlavorSupported) {
            supportedDataFlavorsV.add(DataFlavor.javaFileListFlavor);
        }
        if (this.stringFlavorSupported) {
            supportedDataFlavorsV.add(DataFlavor.stringFlavor);
        }
        if (this.textUriFlavorSupported) {
            supportedDataFlavorsV.add(TEXT_URI_FLAVOR);
        }
        DataFlavor[] supportedDataFlavors = new DataFlavor[supportedDataFlavorsV.size()];
        supportedDataFlavorsV.toArray(supportedDataFlavors);
        return supportedDataFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (dataFlavor.equals(FILE_SET_DATA_FLAVOR)) {
            return this.fileSetFlavorSupported;
        }
        if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
            return this.javaFileListFlavorSupported;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return this.stringFlavorSupported;
        }
        if (dataFlavor.equals(TEXT_URI_FLAVOR)) {
            return this.textUriFlavorSupported;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        int nbFiles = this.fileSet.size();
        if (dataFlavor.equals(FILE_SET_DATA_FLAVOR) && this.fileSetFlavorSupported) {
            return this.fileSet;
        }
        if (dataFlavor.equals(DataFlavor.javaFileListFlavor) && this.javaFileListFlavorSupported) {
            Vector<File> fileList = new Vector<File>(nbFiles);
            for (int i = 0; i < nbFiles; ++i) {
                AbstractFile file = (AbstractFile)this.fileSet.elementAt(i);
                fileList.add(new File(file.getAbsolutePath()));
            }
            return fileList;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor) && this.stringFlavorSupported) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < nbFiles; ++i) {
                AbstractFile file = (AbstractFile)this.fileSet.elementAt(i);
                sb.append(this.stringFlavourTransfersFilename ? file.getName() : file.getAbsolutePath());
                if (i == nbFiles - 1) continue;
                sb.append('\n');
            }
            return sb.toString();
        }
        if (dataFlavor.equals(TEXT_URI_FLAVOR) && this.textUriFlavorSupported) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < nbFiles; ++i) {
                AbstractFile file = (AbstractFile)this.fileSet.elementAt(i);
                String url = file.getURL().getScheme().equals("file") ? new File(file.getAbsolutePath()).toURI().toString() : file.getAbsolutePath();
                sb.append(url);
                if (i == nbFiles - 1) continue;
                sb.append("\r\n");
            }
            return sb.toString();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    static {
        try {
            FILE_SET_DATA_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=" + FileSet.class.getName());
            TEXT_URI_FLAVOR = new DataFlavor("text/uri-list;class=" + String.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.debug("FileSet DataFlavor could not be instantiated", classNotFoundException);
        }
    }
}

