/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.encoding;

import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingPreferences {
    public static final String[] DEFAULT_PREFERRED_ENCODINGS = new String[]{"UTF-8", "UTF-16", "ISO-8859-1", "windows-1252", "KOI8-R", "Big5", "GB18030", "EUC-KR", "Shift_JIS", "ISO-2022-JP", "EUC-JP"};

    public static List<String> getPreferredEncodings() {
        List<String> vector = MuConfigurations.getPreferences().getListVariable(MuPreference.PREFERRED_ENCODINGS, ",");
        if (vector == null) {
            vector = EncodingPreferences.getDefaultPreferredEncodings();
            MuConfigurations.getPreferences().setVariable(MuPreference.PREFERRED_ENCODINGS, vector, ",");
        }
        return vector;
    }

    public static List<String> getDefaultPreferredEncodings() {
        Vector<String> encodingsV = new Vector<String>();
        for (String encoding : DEFAULT_PREFERRED_ENCODINGS) {
            if (!Charset.isSupported(encoding)) continue;
            encodingsV.add(encoding);
        }
        return encodingsV;
    }

    public static void setPreferredEncodings(List<String> encodings) {
        MuConfigurations.getPreferences().setVariable(MuPreference.PREFERRED_ENCODINGS, encodings, ",");
    }
}

