/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.encoding;

import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.encoding.EncodingPreferences;
import com.mucommander.ui.layout.YBoxPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferredEncodingsDialog
extends FocusDialog {
    private List<JCheckBox> checkboxes;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(300, 0);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(550, 400);

    public PreferredEncodingsDialog(Frame owner) {
        super(owner, Translator.get("preferred_encodings", new String[0]), (Component)owner);
        this.init();
    }

    public PreferredEncodingsDialog(Dialog owner) {
        super(owner, Translator.get("preferred_encodings", new String[0]), (Component)owner);
        this.init();
    }

    protected void init() {
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            this.getRootPane().putClientProperty("Window.style", "small");
        }
        Container contentPane = this.getContentPane();
        JLabel label = new JLabel(Translator.get("preferred_encodings", new String[0]) + ":");
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            label.putClientProperty("JComponent.sizeVariant", "small");
        }
        contentPane.add((Component)label, "North");
        YBoxPanel yPanel = new YBoxPanel();
        this.checkboxes = new Vector<JCheckBox>();
        for (String enc : Charset.availableCharsets().keySet()) {
            JCheckBox checkbox = new JCheckBox(enc);
            if (OsFamilies.MAC_OS_X.isCurrent()) {
                checkbox.putClientProperty("JComponent.sizeVariant", "small");
            }
            this.checkboxes.add(checkbox);
            yPanel.add(checkbox);
        }
        this.selectCheckboxes(EncodingPreferences.getPreferredEncodings());
        JScrollPane scrollPane = new JScrollPane(yPanel, 20, 31);
        contentPane.add((Component)scrollPane, "Center");
        JButton defaultsButton = new JButton(Translator.get("reset", new String[0]));
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            defaultsButton.putClientProperty("JComponent.sizeVariant", "small");
        }
        defaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferredEncodingsDialog.this.selectCheckboxes(EncodingPreferences.getDefaultPreferredEncodings());
            }
        });
        JPanel flowPanel = new JPanel(new FlowLayout(4));
        flowPanel.add(defaultsButton);
        contentPane.add((Component)flowPanel, "South");
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                int nbCheckboxes = PreferredEncodingsDialog.this.checkboxes.size();
                Vector<String> preferredEncodings = new Vector<String>();
                for (int i = 0; i < nbCheckboxes; ++i) {
                    JCheckBox checkbox = (JCheckBox)PreferredEncodingsDialog.this.checkboxes.get(i);
                    if (!checkbox.isSelected()) continue;
                    preferredEncodings.add(checkbox.getText());
                }
                EncodingPreferences.setPreferredEncodings(preferredEncodings);
            }
        });
    }

    protected void selectCheckboxes(List<String> selectedEncodings) {
        int nbCheckboxes = this.checkboxes.size();
        for (int i = 0; i < nbCheckboxes; ++i) {
            JCheckBox checkbox = this.checkboxes.get(i);
            checkbox.setSelected(selectedEncodings.contains(checkbox.getText()));
        }
    }
}

