/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.icon;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.icon.FileIconProvider;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.ui.icon.CustomFileIconProvider;
import com.mucommander.ui.icon.IconManager;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class FileIcons {
    private static String systemIconsPolicy = "applications";
    private static float scaleFactor = 1.0f;
    private static FileIconProvider customFileIconProvider;
    private static FileIconProvider systemFileIconProvider;
    private static Dimension iconDimension;

    public static Icon getFileIcon(AbstractFile file) {
        return FileIcons.getFileIcon(file, iconDimension);
    }

    public static Icon getFileIcon(AbstractFile file, Dimension iconDimension) {
        Icon icon;
        boolean systemIcon = false;
        if ("always".equals(systemIconsPolicy)) {
            systemIcon = true;
        }
        if ("applications".equals(systemIconsPolicy)) {
            systemIcon = DesktopManager.isApplication(file);
        }
        if (systemIcon && (icon = FileIcons.getSystemFileIcon(file, iconDimension)) != null) {
            return icon;
        }
        return FileIcons.getCustomFileIcon(file, iconDimension);
    }

    public static Icon getCustomFileIcon(AbstractFile file, Dimension iconDimension) {
        return FileIcons.getFileProviderIcon(customFileIconProvider, file, iconDimension);
    }

    public static Icon getSystemFileIcon(AbstractFile file) {
        return FileIcons.getSystemFileIcon(file, iconDimension);
    }

    public static Icon getSystemFileIcon(AbstractFile file, Dimension iconDimension) {
        return FileIcons.getFileProviderIcon(systemFileIconProvider, file, iconDimension);
    }

    private static Icon getFileProviderIcon(FileIconProvider fip, AbstractFile file, Dimension iconDimension) {
        Icon icon = fip.getFileIcon(file, iconDimension);
        if (icon == null) {
            return null;
        }
        if (iconDimension.width == icon.getIconWidth() && iconDimension.height == icon.getIconHeight()) {
            return icon;
        }
        ImageIcon imageIcon = IconManager.getImageIcon(icon);
        return new ImageIcon(imageIcon.getImage().getScaledInstance(iconDimension.width, iconDimension.height, 16));
    }

    public static void setCustomFileIconProvider(FileIconProvider fip) {
        customFileIconProvider = fip;
    }

    public static void setSystemFileIconProvider(FileIconProvider fip) {
        systemFileIconProvider = fip;
    }

    public static Dimension getIconDimension() {
        return iconDimension;
    }

    public static float getScaleFactor() {
        return scaleFactor;
    }

    public static void setScaleFactor(float factor) {
        if (scaleFactor <= 0.0f) {
            throw new IllegalArgumentException("Scale factor must be greater than 0, (" + factor + ")");
        }
        scaleFactor = factor;
        iconDimension = new Dimension((int)(16.0f * scaleFactor), (int)(16.0f * scaleFactor));
    }

    public static String getSystemIconsPolicy() {
        return systemIconsPolicy;
    }

    public static void setSystemIconsPolicy(String policy) {
        systemIconsPolicy = policy;
    }

    public static boolean hasProperSystemIcons() {
        return OsFamilies.MAC_OS_X.isCurrent() || OsFamilies.WINDOWS.isCurrent();
    }

    static {
        iconDimension = new Dimension(16, 16);
        FileIcons.setCustomFileIconProvider(new CustomFileIconProvider());
        FileIcons.setSystemFileIconProvider(FileFactory.getDefaultFileIconProvider());
    }
}

