/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.icon;

import com.mucommander.commons.file.util.ResourceLoader;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IconManager.class);
    private static final Map<String, ImageIcon>[] caches;
    private static final String[] ICON_SET_FOLDERS;

    private IconManager() {
    }

    public static ImageIcon getIcon(String iconPath, float scaleFactor) {
        URL resourceURL = ResourceLoader.getResourceAsURL(iconPath);
        if (resourceURL == null) {
            LOGGER.debug("Warning: attempt to load non-existing icon: " + iconPath + " , icon missing ?");
            return null;
        }
        ImageIcon icon = new ImageIcon(resourceURL);
        return scaleFactor == 1.0f ? icon : IconManager.getScaledIcon(icon, scaleFactor);
    }

    public static ImageIcon getIcon(String iconPath) {
        return IconManager.getIcon(iconPath, 1.0f);
    }

    public static ImageIcon getScaledIcon(ImageIcon icon, float scaleFactor) {
        if (scaleFactor == 1.0f || icon == null) {
            return icon;
        }
        Image image = icon.getImage();
        return new ImageIcon(image.getScaledInstance((int)(scaleFactor * (float)image.getWidth(null)), (int)(scaleFactor * (float)image.getHeight(null)), 16));
    }

    public static ImageIcon getCompositeIcon(Icon backgroundIcon, Icon foregroundIcon) {
        BufferedImage bi = new BufferedImage(backgroundIcon.getIconWidth(), backgroundIcon.getIconHeight(), 2);
        Graphics g = bi.getGraphics();
        backgroundIcon.paintIcon(null, g, 0, 0);
        foregroundIcon.paintIcon(null, g, 0, 0);
        return new ImageIcon(bi);
    }

    public static ImageIcon getIcon(int iconSet, String iconName, float scaleFactor) {
        ImageIcon icon;
        Map<String, ImageIcon> cache = caches[iconSet];
        if (cache == null) {
            icon = IconManager.getIcon(ICON_SET_FOLDERS[iconSet] + iconName);
        } else {
            icon = cache.get(iconName);
            if (icon == null && (icon = IconManager.getIcon(ICON_SET_FOLDERS[iconSet] + iconName)) != null) {
                cache.put(iconName, icon);
            }
        }
        if (icon == null) {
            return null;
        }
        return scaleFactor == 1.0f ? icon : IconManager.getScaledIcon(icon, scaleFactor);
    }

    public static ImageIcon getIcon(int iconSet, String iconName) {
        return IconManager.getIcon(iconSet, iconName, 1.0f);
    }

    public static ImageIcon getPaddedIcon(ImageIcon icon, Insets insets) {
        BufferedImage bi = new BufferedImage(icon.getIconWidth() + insets.left + insets.right, icon.getIconHeight() + insets.top + insets.bottom, 2);
        Graphics g = bi.getGraphics();
        g.drawImage(icon.getImage(), insets.left, insets.top, null);
        return new ImageIcon(bi);
    }

    public static ImageIcon getImageIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(null, bi.getGraphics(), 0, 0);
        return new ImageIcon(bi);
    }

    public static String getIconSetFolder(int iconSet) {
        return ICON_SET_FOLDERS[iconSet];
    }

    static {
        ICON_SET_FOLDERS = new String[]{"/images/file/", "/images/action/", "/images/status_bar/", "/images/common/", "/images/preferences/", "/images/progress/", "/images/language/", "/images/mucommander/"};
        caches = new Hashtable[ICON_SET_FOLDERS.length];
        IconManager.caches[0] = new Hashtable<String, ImageIcon>();
        IconManager.caches[1] = new Hashtable<String, ImageIcon>();
        IconManager.caches[2] = new Hashtable<String, ImageIcon>();
        IconManager.caches[3] = new Hashtable<String, ImageIcon>();
        IconManager.caches[5] = new Hashtable<String, ImageIcon>();
    }
}

