/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.layout;

import com.mucommander.text.Translator;
import com.mucommander.ui.icon.SpinningDial;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public abstract class AsyncPanel
extends JPanel {
    private JComponent waitComponent;
    private boolean visibleOnScreen;

    public AsyncPanel() {
        this(AsyncPanel.getDefaultWaitComponent());
    }

    public AsyncPanel(JComponent waitComponent) {
        super(new BorderLayout());
        this.waitComponent = waitComponent;
        this.add((Component)waitComponent, "Center");
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent e) {
                if (AsyncPanel.this.visibleOnScreen) {
                    return;
                }
                AsyncPanel.this.visibleOnScreen = true;
                AsyncPanel.this.removeAncestorListener(this);
                AsyncPanel.this.loadTargetComponent();
            }

            public void ancestorRemoved(AncestorEvent event) {
            }

            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private void loadTargetComponent() {
        new Thread(){

            public void run() {
                JComponent targetComponent = AsyncPanel.this.getTargetComponent();
                AsyncPanel.this.remove(AsyncPanel.this.waitComponent);
                AsyncPanel.this.setBorder(new EmptyBorder(0, 0, 0, 0));
                AsyncPanel.this.add((Component)targetComponent, "Center");
                AsyncPanel.this.updateLayout();
            }
        }.start();
    }

    private static JComponent getDefaultWaitComponent() {
        JLabel label = new JLabel(Translator.get("loading", new String[0]));
        label.setIcon(new SpinningDial(24, 24, true));
        JPanel tempPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        tempPanel.add((Component)label, gbc);
        return tempPanel;
    }

    protected void updateLayout() {
        Container tla = this.getTopLevelAncestor();
        if (tla instanceof Window) {
            ((Window)tla).pack();
        }
    }

    public abstract JComponent getTargetComponent();
}

