/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.layout;

import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.text.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class InformationPane
extends JPanel {
    private JLabel iconLabel;
    private MultiLineLabel mainLabel;
    private MultiLineLabel captionLabel;

    public InformationPane() {
        this("", "");
    }

    public InformationPane(String mainMessage, String captionMessage) {
        this(mainMessage, captionMessage, 1, null);
    }

    public InformationPane(String mainMessage, String captionMessage, int mainMessageFontStyle, int predefinedIconId) {
        this(mainMessage, captionMessage, mainMessageFontStyle, InformationPane.getPredefinedIcon(predefinedIconId));
    }

    public InformationPane(String mainMessage, String captionMessage, int mainMessageFontStyle, Icon icon) {
        super(new BorderLayout());
        if (icon != null) {
            this.setIcon(icon);
        }
        YBoxPanel yPanel = new YBoxPanel(5);
        this.mainLabel = new MultiLineLabel(mainMessage);
        if (mainMessageFontStyle != 0) {
            this.setMainLabelFontStyle(mainMessageFontStyle);
        }
        yPanel.add(this.mainLabel);
        yPanel.addSpace(5);
        this.captionLabel = new MultiLineLabel(captionMessage);
        Font labelFont = this.mainLabel.getFont();
        this.captionLabel.setFont(labelFont.deriveFont(0, labelFont.getSize() - 2));
        yPanel.add(this.captionLabel);
        this.add((Component)yPanel, "Center");
    }

    public static Icon getPredefinedIcon(int predefinedIconId) {
        String optionPaneIcon;
        switch (predefinedIconId) {
            case 1: {
                optionPaneIcon = "errorIcon";
                break;
            }
            case 2: {
                optionPaneIcon = "informationIcon";
                break;
            }
            case 3: {
                optionPaneIcon = "warningIcon";
                break;
            }
            case 4: {
                optionPaneIcon = "questionIcon";
                break;
            }
            default: {
                return null;
            }
        }
        return UIManager.getIcon("OptionPane." + optionPaneIcon);
    }

    public MultiLineLabel getMainLabel() {
        return this.mainLabel;
    }

    public MultiLineLabel getCaptionLabel() {
        return this.captionLabel;
    }

    public void setIcon(Icon icon) {
        if (icon == null) {
            if (this.iconLabel != null) {
                this.remove(this.iconLabel);
                this.iconLabel = null;
            }
        } else {
            if (this.iconLabel == null) {
                this.iconLabel = new JLabel(" ");
                this.add((Component)this.iconLabel, "West");
            }
            this.iconLabel.setIcon(icon);
        }
    }

    public void setMainLabelFontStyle(int fontStyle) {
        Font labelFont = this.mainLabel.getFont();
        this.mainLabel.setFont(labelFont.deriveFont(fontStyle, labelFont.getSize()));
    }
}

