/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.list;

import com.mucommander.commons.collections.AlteredVector;
import com.mucommander.text.Translator;
import com.mucommander.ui.button.ArrowButton;
import com.mucommander.ui.list.DynamicList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableListPanel<E>
extends JPanel {
    private DynamicList<E> dynamicList;

    public SortableListPanel(AlteredVector<E> items) {
        super(new BorderLayout());
        this.dynamicList = new DynamicList<E>(items);
        this.add((Component)new JScrollPane(this.dynamicList), "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1));
        ArrowButton moveButton = new ArrowButton(this.dynamicList.getMoveUpAction(), 0);
        moveButton.setPreferredSize(new Dimension(19, 0));
        moveButton.setFocusable(false);
        moveButton.setToolTipText(Translator.get("sortable_list.move_up", new String[0]));
        buttonPanel.add(moveButton);
        moveButton = new ArrowButton(this.dynamicList.getMoveDownAction(), 1);
        moveButton.setPreferredSize(new Dimension(19, 0));
        moveButton.setFocusable(false);
        moveButton.setToolTipText(Translator.get("sortable_list.move_down", new String[0]));
        buttonPanel.add(moveButton);
        this.add((Component)buttonPanel, "East");
    }

    public DynamicList<E> getDynamicList() {
        return this.dynamicList;
    }
}

