/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.macosx;

import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.process.AbstractProcess;
import com.mucommander.process.ProcessListener;
import com.mucommander.process.ProcessRunner;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppleScript {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppleScript.class);

    public static boolean execute(String appleScript, StringBuilder outputBuffer) {
        if (!OsFamilies.MAC_OS_X.isCurrent()) {
            return false;
        }
        LOGGER.debug("Executing AppleScript: " + appleScript);
        String[] tokens = new String[]{"osascript", "-s", "o"};
        OutputStreamWriter pout = null;
        try {
            AbstractProcess process = ProcessRunner.execute(tokens, outputBuffer == null ? null : new ScriptOutputListener(outputBuffer, AppleScript.getScriptEncoding()));
            pout = new OutputStreamWriter(process.getOutputStream(), AppleScript.getScriptEncoding());
            pout.write(appleScript);
            pout.close();
            int returnCode = process.waitFor();
            LOGGER.debug("osascript returned code=" + returnCode + ", output=" + outputBuffer);
            if (returnCode != 0) {
                LOGGER.debug("osascript terminated abnormally");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.debug("Unexcepted exception while executing AppleScript", e);
            try {
                if (pout != null) {
                    pout.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            return false;
        }
    }

    public static String getScriptEncoding() {
        String encoding = OsVersions.MAC_OS_X_10_5.isCurrentOrHigher() ? "UTF-8" : "MacRoman";
        return encoding;
    }

    private static class ScriptOutputListener
    implements ProcessListener {
        private StringBuilder outputBuffer;
        private String outputEncoding;

        private ScriptOutputListener(StringBuilder outputBuffer, String outputEncoding) {
            this.outputBuffer = outputBuffer;
            this.outputEncoding = outputEncoding;
        }

        public void processOutput(byte[] buffer, int offset, int length) {
            try {
                this.outputBuffer.append(new String(buffer, offset, length, this.outputEncoding));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }

        public void processOutput(String s) {
        }

        public void processDied(int returnValue) {
            int len = this.outputBuffer.length();
            if (len > 0 && this.outputBuffer.charAt(len - 1) == '\n') {
                this.outputBuffer.setLength(len - 1);
            }
        }
    }
}

