/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.macosx;

import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.dialog.about.AboutDialog;
import com.mucommander.ui.dialog.shutdown.QuitDialog;
import com.mucommander.ui.macosx.EAWTHandler;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.WindowManager;

public class OSXIntegration {
    public OSXIntegration() {
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            if (OsVersions.MAC_OS_X_10_4.isCurrentOrLower()) {
                System.setProperty("apple.awt.brushMetalLook", "" + MuConfigurations.getPreferences().getVariable(MuPreference.USE_BRUSHED_METAL, false));
            }
            System.setProperty("apple.laf.useScreenMenuBar", "" + MuConfigurations.getPreferences().getVariable(MuPreference.USE_SCREEN_MENU_BAR, true));
            new EAWTHandler();
        }
    }

    public static void showAbout() {
        MainFrame mainFrame = WindowManager.getCurrentMainFrame();
        if (mainFrame.getNoEventsMode()) {
            return;
        }
        new AboutDialog(mainFrame).showDialog();
    }

    public static void showPreferences() {
        MainFrame mainFrame = WindowManager.getCurrentMainFrame();
        if (mainFrame.getNoEventsMode()) {
            return;
        }
        ActionManager.performAction("ShowPreferences", mainFrame);
    }

    public static boolean doQuit() {
        if (!QuitDialog.confirmQuit()) {
            return false;
        }
        WindowManager.quit();
        return true;
    }
}

