/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main;

import com.mucommander.bonjour.BonjourMenu;
import com.mucommander.bonjour.BonjourService;
import com.mucommander.bookmark.Bookmark;
import com.mucommander.bookmark.BookmarkListener;
import com.mucommander.bookmark.BookmarkManager;
import com.mucommander.commons.collections.AlteredVector;
import com.mucommander.commons.conf.ConfigurationEvent;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.filter.PathFilter;
import com.mucommander.commons.file.filter.RegexpPathFilter;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.action.impl.OpenLocationAction;
import com.mucommander.ui.button.PopupButton;
import com.mucommander.ui.dialog.server.FTPPanel;
import com.mucommander.ui.dialog.server.HTTPPanel;
import com.mucommander.ui.dialog.server.NFSPanel;
import com.mucommander.ui.dialog.server.SFTPPanel;
import com.mucommander.ui.dialog.server.SMBPanel;
import com.mucommander.ui.dialog.server.ServerConnectDialog;
import com.mucommander.ui.dialog.server.ServerPanel;
import com.mucommander.ui.event.LocationEvent;
import com.mucommander.ui.event.LocationListener;
import com.mucommander.ui.helper.MnemonicHelper;
import com.mucommander.ui.icon.FileIcons;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrivePopupButton
extends PopupButton
implements BookmarkListener,
ConfigurationListener,
LocationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrivePopupButton.class);
    private FolderPanel folderPanel;
    private static AbstractFile[] volumes;
    private static FileSystemView fileSystemView;
    private static Map<AbstractFile, String> extendedNameCache;
    private static Map<AbstractFile, Icon> iconCache;
    private static PathFilter volumeFilter;

    public DrivePopupButton(FolderPanel folderPanel) {
        this.folderPanel = folderPanel;
        folderPanel.getLocationManager().addLocationListener(this);
        BookmarkManager.addBookmarkListener(this);
        MuConfigurations.addPreferencesListener(this);
        if (OsFamilies.MAC_OS_X.isCurrent() && OsVersions.MAC_OS_X_10_5.isCurrentOrHigher()) {
            this.setMargin(new Insets(6, 8, 6, 8));
            this.putClientProperty("JComponent.sizeVariant", "small");
            this.putClientProperty("JButton.buttonType", "textured");
        }
    }

    private void updateButton() {
        AbstractFile currentFolder = this.folderPanel.getCurrentFolder();
        String currentPath = currentFolder.getAbsolutePath();
        FileURL currentURL = currentFolder.getURL();
        String newLabel = null;
        AlteredVector<Bookmark> bookmarks = BookmarkManager.getBookmarks();
        int nbBookmarks = bookmarks.size();
        for (int i = 0; i < nbBookmarks; ++i) {
            Bookmark b = (Bookmark)bookmarks.get(i);
            if (!currentPath.equals(b.getLocation())) continue;
            newLabel = b.getName();
            break;
        }
        if (newLabel == null) {
            String protocol = currentURL.getScheme();
            if (!protocol.equals("file")) {
                newLabel = protocol.toUpperCase();
            } else if (OsFamilies.WINDOWS.isCurrent() && !"localhost".equals(currentURL.getHost())) {
                newLabel = "SMB";
            } else {
                currentPath = OsFamilies.WINDOWS.isCurrent() ? currentFolder.getAbsolutePath(false).toLowerCase() : currentFolder.getCanonicalPath(false).toLowerCase();
                int bestLength = -1;
                int bestIndex = 0;
                for (int i = 0; i < volumes.length; ++i) {
                    String temp = OsFamilies.WINDOWS.isCurrent() ? volumes[i].getAbsolutePath(false).toLowerCase() : volumes[i].getCanonicalPath(false).toLowerCase();
                    int len = temp.length();
                    if (!currentPath.startsWith(temp) || len <= bestLength) continue;
                    bestIndex = i;
                    bestLength = len;
                }
                newLabel = volumes[bestIndex].getName();
            }
        }
        this.setText(newLabel);
        this.setIcon(FileIcons.getFileIcon(currentFolder));
    }

    private static String getExtendedDriveName(AbstractFile localFile) {
        String name = fileSystemView.getSystemDisplayName((File)localFile.getUnderlyingFileObject());
        if (name == null || name.equals("")) {
            return localFile.getName();
        }
        return name;
    }

    public static AbstractFile[] getDisplayableVolumes() {
        AbstractFile[] volumes = LocalFile.getVolumes();
        if (volumeFilter != null) {
            return volumeFilter.filter(volumes);
        }
        return volumes;
    }

    public JPopupMenu getPopupMenu() {
        Object object;
        JMenuItem jMenuItem;
        CustomOpenLocationAction customOpenLocationAction;
        JPopupMenu jPopupMenu = new JPopupMenu();
        volumes = DrivePopupButton.getDisplayableVolumes();
        int n = volumes.length;
        final MainFrame mainFrame = this.folderPanel.getMainFrame();
        MnemonicHelper mnemonicHelper = new MnemonicHelper();
        boolean bl = fileSystemView != null;
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        for (int i = 0; i < n; ++i) {
            customOpenLocationAction = new CustomOpenLocationAction(mainFrame, new Hashtable<String, Object>(), volumes[i]);
            String string = volumes[i].getName();
            for (int j = 0; j < n; ++j) {
                if (j == i || !volumes[j].getName().equalsIgnoreCase(string)) continue;
                customOpenLocationAction.setLabel(volumes[i].getAbsolutePath());
                break;
            }
            jMenuItem = jPopupMenu.add(customOpenLocationAction);
            this.setMnemonic(jMenuItem, mnemonicHelper);
            Icon icon = iconCache.get(volumes[i]);
            if (icon != null) {
                jMenuItem.setIcon(icon);
            }
            if (bl && (object = extendedNameCache.get(volumes[i])) != null) {
                jMenuItem.setText((String)object);
            }
            arrayList.add(jMenuItem);
        }
        new RefreshDriveNamesAndIcons(jPopupMenu, arrayList).start();
        jPopupMenu.add(new JSeparator());
        AlteredVector<Bookmark> alteredVector = BookmarkManager.getBookmarks();
        int n2 = alteredVector.size();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                object = (Bookmark)alteredVector.get(i);
                jMenuItem = jPopupMenu.add(new CustomOpenLocationAction(mainFrame, new Hashtable<String, Object>(), (Bookmark)object));
                this.setMnemonic(jMenuItem, mnemonicHelper);
            }
        } else {
            jPopupMenu.add(Translator.get("bookmarks_menu.no_bookmark", new String[0])).setEnabled(false);
        }
        jPopupMenu.add(new JSeparator());
        if (FileFactory.isRegisteredProtocol("smb")) {
            customOpenLocationAction = new CustomOpenLocationAction(mainFrame, new Hashtable<String, Object>(), new Bookmark(Translator.get("drive_popup.network_shares", new String[0]), "smb:///"));
            customOpenLocationAction.setIcon(IconManager.getIcon(0, "network.png"));
            this.setMnemonic(jPopupMenu.add(customOpenLocationAction), mnemonicHelper);
        }
        this.setMnemonic(jPopupMenu.add(new BonjourMenu(){

            public MuAction getMenuItemAction(BonjourService bs) {
                return new CustomOpenLocationAction(mainFrame, new Hashtable<String, Object>(), bs);
            }
        }), mnemonicHelper);
        jPopupMenu.add(new JSeparator());
        this.setMnemonic(jPopupMenu.add(new ServerConnectAction("SMB...", SMBPanel.class)), mnemonicHelper);
        this.setMnemonic(jPopupMenu.add(new ServerConnectAction("FTP...", FTPPanel.class)), mnemonicHelper);
        this.setMnemonic(jPopupMenu.add(new ServerConnectAction("SFTP...", SFTPPanel.class)), mnemonicHelper);
        this.setMnemonic(jPopupMenu.add(new ServerConnectAction("HTTP...", HTTPPanel.class)), mnemonicHelper);
        this.setMnemonic(jPopupMenu.add(new ServerConnectAction("NFS...", NFSPanel.class)), mnemonicHelper);
        return jPopupMenu;
    }

    private void setMnemonic(JMenuItem menuItem, MnemonicHelper mnemonicHelper) {
        menuItem.setMnemonic(mnemonicHelper.getMnemonic(menuItem.getText()));
    }

    public void bookmarksChanged() {
        this.updateButton();
    }

    public void configurationChanged(ConfigurationEvent event) {
        String var = event.getVariable();
        if (var.equals("file_table.use_system_file_icons")) {
            this.updateButton();
        }
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (d.width > 160) {
            d.width = 160;
        }
        return d;
    }

    public void locationChanged(LocationEvent e) {
        this.updateButton();
    }

    public void locationChanging(LocationEvent locationEvent) {
    }

    public void locationCancelled(LocationEvent locationEvent) {
    }

    public void locationFailed(LocationEvent locationEvent) {
    }

    static {
        iconCache = new Hashtable<AbstractFile, Icon>();
        if (OsFamilies.WINDOWS.isCurrent()) {
            fileSystemView = FileSystemView.getFileSystemView();
            extendedNameCache = new Hashtable<AbstractFile, String>();
        }
        try {
            String string = MuConfigurations.getPreferences().getVariable(MuPreference.VOLUME_EXCLUDE_REGEXP);
            if (string != null) {
                volumeFilter = new RegexpPathFilter(string, true);
                volumeFilter.setInverted(true);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            LOGGER.info("Invalid regexp for conf variable volume_list.exclude_regexp", patternSyntaxException);
        }
        volumes = DrivePopupButton.getDisplayableVolumes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomOpenLocationAction
    extends OpenLocationAction {
        public CustomOpenLocationAction(MainFrame mainFrame, Map<String, Object> properties, Bookmark bookmark) {
            super(mainFrame, properties, bookmark);
        }

        public CustomOpenLocationAction(MainFrame mainFrame, Map<String, Object> properties, AbstractFile file) {
            super(mainFrame, properties, file);
        }

        public CustomOpenLocationAction(MainFrame mainFrame, Map<String, Object> properties, BonjourService bs) {
            super(mainFrame, properties, bs);
        }

        @Override
        protected FolderPanel getFolderPanel() {
            return DrivePopupButton.this.folderPanel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServerConnectAction
    extends AbstractAction {
        private Class<? extends ServerPanel> serverPanelClass;

        private ServerConnectAction(String label, Class<? extends ServerPanel> serverPanelClass) {
            super(label);
            this.serverPanelClass = serverPanelClass;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ServerConnectDialog(DrivePopupButton.this.folderPanel, this.serverPanelClass).showDialog();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RefreshDriveNamesAndIcons
    extends Thread {
        private JPopupMenu popupMenu;
        private ArrayList<JMenuItem> items;

        public RefreshDriveNamesAndIcons(JPopupMenu popupMenu, ArrayList<JMenuItem> items) {
            super("RefreshDriveNamesAndIcons");
            this.popupMenu = popupMenu;
            this.items = items;
        }

        @Override
        public void run() {
            final boolean useExtendedDriveNames = fileSystemView != null;
            for (int i = 0; i < this.items.size(); ++i) {
                Icon icon;
                final JMenuItem item = this.items.get(i);
                String extendedName = null;
                if (useExtendedDriveNames) {
                    extendedName = DrivePopupButton.getExtendedDriveName(volumes[i]);
                    extendedNameCache.put(volumes[i], extendedName);
                }
                final String extendedNameFinal = extendedName;
                Icon icon2 = icon = FileIcons.hasProperSystemIcons() ? FileIcons.getSystemFileIcon(volumes[i]) : null;
                if (icon != null) {
                    iconCache.put(volumes[i], icon);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (useExtendedDriveNames) {
                            item.setText(extendedNameFinal);
                        }
                        if (icon != null) {
                            item.setIcon(icon);
                        }
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RefreshDriveNamesAndIcons.this.popupMenu.invalidate();
                    RefreshDriveNamesAndIcons.this.popupMenu.pack();
                }
            });
        }
    }
}

