/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main;

import com.mucommander.auth.CredentialsManager;
import com.mucommander.auth.CredentialsMapping;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.AuthenticationType;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.impl.CachedFile;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionKeymap;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.QuestionDialog;
import com.mucommander.ui.dialog.auth.AuthDialog;
import com.mucommander.ui.dialog.file.DownloadDialog;
import com.mucommander.ui.dnd.FileDragSourceListener;
import com.mucommander.ui.dnd.FileDropTargetListener;
import com.mucommander.ui.event.LocationAdapter;
import com.mucommander.ui.event.LocationEvent;
import com.mucommander.ui.event.LocationListener;
import com.mucommander.ui.event.LocationManager;
import com.mucommander.ui.main.ConfigurableFolderFilter;
import com.mucommander.ui.main.DrivePopupButton;
import com.mucommander.ui.main.LocationHistory;
import com.mucommander.ui.main.LocationTextField;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.quicklist.BookmarksQL;
import com.mucommander.ui.main.quicklist.ParentFoldersQL;
import com.mucommander.ui.main.quicklist.RecentExecutedFilesQL;
import com.mucommander.ui.main.quicklist.RecentLocationsQL;
import com.mucommander.ui.main.quicklist.RootFoldersQL;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.main.table.FileTableConfiguration;
import com.mucommander.ui.main.table.FolderChangeMonitor;
import com.mucommander.ui.main.tabs.FileTableTabs;
import com.mucommander.ui.main.tree.FoldersTreePanel;
import com.mucommander.ui.quicklist.QuickList;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderPanel
extends JPanel
implements FocusListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderPanel.class);
    private MainFrame mainFrame;
    private AbstractFile currentFolder;
    private ChangeFolderThread changeFolderThread;
    private long lastFolderChangeTime;
    private FolderChangeMonitor folderChangeMonitor;
    private LocationManager locationManager = new LocationManager(this);
    private LocationListener locationListener;
    private DrivePopupButton driveButton;
    private LocationTextField locationTextField;
    private FileTable fileTable;
    private FileTableTabs tabs;
    private FoldersTreePanel foldersTreePanel;
    private JSplitPane treeSplitPane;
    private LocationHistory folderHistory = new LocationHistory(this);
    private FileDragSourceListener fileDragSourceListener;
    private ConfigurableFolderFilter configurableFolderFilter = new ConfigurableFolderFilter();
    private final Object FOLDER_CHANGE_LOCK = new Object();
    private static final String CANCEL_TEXT = Translator.get("cancel", new String[0]);
    private static final String BROWSE_TEXT = Translator.get("browse", new String[0]);
    private static final String DOWNLOAD_TEXT = Translator.get("download", new String[0]);
    private boolean treeVisible = false;
    private int oldTreeWidth = 150;
    private QuickList[] fileTablePopups;
    protected static RecentLocationsQL recentLocationsQL = new RecentLocationsQL();
    protected static RecentExecutedFilesQL recentExecutedFilesQL = new RecentExecutedFilesQL();
    protected static BookmarksQL bookmarksQL = new BookmarksQL();
    protected static RootFoldersQL rootsQL = new RootFoldersQL();

    FolderPanel(MainFrame mainFrame, AbstractFile initialFolder, FileTableConfiguration conf) {
        this(mainFrame, new AbstractFile[]{initialFolder}, conf);
    }

    FolderPanel(MainFrame mainFrame, AbstractFile[] initialFolders, FileTableConfiguration conf) {
        super(new BorderLayout());
        LOGGER.trace(" initialFolder:" + initialFolders);
        for (AbstractFile folder : initialFolders) {
            LOGGER.trace("\t" + folder);
        }
        this.mainFrame = mainFrame;
        this.setBorder(null);
        JPanel locationPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridy = 0;
        this.driveButton = new DrivePopupButton(this);
        c.weightx = 0.0;
        c.gridx = 0;
        locationPanel.add((Component)this.driveButton, c);
        this.locationTextField = new LocationTextField(this);
        c.weightx = 1.0;
        c.gridx = 1;
        c.insets = new Insets(0, 4, 0, 0);
        locationPanel.add((Component)this.locationTextField, c);
        this.add((Component)locationPanel, "North");
        this.fileTable = new FileTable(mainFrame, this, conf);
        this.locationManager.addLocationListener(recentLocationsQL);
        this.fileTablePopups = new QuickList[]{new ParentFoldersQL(this), recentLocationsQL, recentExecutedFilesQL, bookmarksQL, rootsQL};
        this.locationListener = new LocationAdapter(){

            public void locationChanged(LocationEvent locationEvent) {
                final 1 thisLocationListenerInstance = this;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FolderPanel.this.folderChangeMonitor = new FolderChangeMonitor(FolderPanel.this);
                        FolderPanel.this.locationManager.removeLocationListener(thisLocationListenerInstance);
                        FolderPanel.this.locationListener = null;
                    }
                });
            }
        };
        this.locationManager.addLocationListener(this.locationListener);
        this.tabs = new FileTableTabs(mainFrame, this, initialFolders);
        this.foldersTreePanel = new FoldersTreePanel(this);
        this.foldersTreePanel.setVisible(false);
        this.treeSplitPane = new JSplitPane(1, this.foldersTreePanel, this.tabs);
        this.treeSplitPane.setDividerSize(0);
        this.treeSplitPane.setDividerLocation(0);
        this.treeSplitPane.setBorder(null);
        this.add((Component)this.treeSplitPane, "Center");
        this.disableCtrlFocusTraversalKeys(this.locationTextField);
        this.disableCtrlFocusTraversalKeys(this.foldersTreePanel.getTree());
        this.disableCtrlFocusTraversalKeys(this.fileTable);
        this.disableCtrlFocusTraversalKeys(this.tabs);
        this.registerCycleThruFolderPanelAction(this.locationTextField);
        this.registerCycleThruFolderPanelAction(this.foldersTreePanel.getTree());
        this.fileTable.addFocusListener(this);
        this.locationTextField.addFocusListener(this);
        this.tabs.addFocusListener(this);
        this.fileDragSourceListener = new FileDragSourceListener(this);
        this.fileDragSourceListener.enableDrag(this.fileTable);
        FileDropTargetListener dropTargetListener = new FileDropTargetListener(this, true);
        this.locationTextField.setDropTarget(new DropTarget(this.locationTextField, dropTargetListener));
        this.driveButton.setDropTarget(new DropTarget(this.driveButton, dropTargetListener));
    }

    private void disableCtrlFocusTraversalKeys(Component component) {
        HashSet<AWTKeyStroke> keyStrokeSet = new HashSet<AWTKeyStroke>();
        keyStrokeSet.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        component.setFocusTraversalKeys(0, keyStrokeSet);
        keyStrokeSet = new HashSet();
        keyStrokeSet.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
        component.setFocusTraversalKeys(1, keyStrokeSet);
    }

    private void registerCycleThruFolderPanelAction(JComponent component) {
        ActionKeymap.registerActionAccelerators(ActionManager.getActionInstance("FocusNext", this.mainFrame), component, 0);
        ActionKeymap.registerActionAccelerators(ActionManager.getActionInstance("FocusPrevious", this.mainFrame), component, 0);
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public FileTable getFileTable() {
        return this.fileTable;
    }

    public FileTableTabs getTabs() {
        return this.tabs;
    }

    public LocationTextField getLocationTextField() {
        return this.locationTextField;
    }

    public DrivePopupButton getDriveButton() {
        return this.driveButton;
    }

    public LocationHistory getFolderHistory() {
        return this.folderHistory;
    }

    public LocationManager getLocationManager() {
        return this.locationManager;
    }

    public void changeCurrentLocation() {
        this.locationTextField.selectAll();
        this.locationTextField.requestFocus();
    }

    public AbstractFile getCurrentFolder() {
        return this.currentFolder;
    }

    private void showFolderDoesNotExistDialog() {
        InformationDialog.showErrorDialog(this.mainFrame, Translator.get("table.folder_access_error_title", new String[0]), Translator.get("folder_does_not_exist", new String[0]));
    }

    private void showAccessErrorDialog(Exception e) {
        InformationDialog.showErrorDialog(this.mainFrame, Translator.get("table.folder_access_error_title", new String[0]), Translator.get("table.folder_access_error", new String[0]), e == null ? null : e.getMessage(), e);
    }

    private AuthDialog popAuthDialog(FileURL fileURL, boolean authFailed, String errorMessage) {
        AuthDialog authDialog = new AuthDialog(this.mainFrame, fileURL, authFailed, errorMessage);
        authDialog.showDialog();
        return authDialog;
    }

    private void showDownloadDialog(AbstractFile file) {
        FileSet fileSet = new FileSet(this.currentFolder);
        fileSet.add(file);
        new DownloadDialog(this.mainFrame, fileSet).showDialog();
    }

    public ChangeFolderThread tryChangeCurrentFolder(AbstractFile folder) {
        return this.tryChangeCurrentFolder(folder, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeFolderThread tryChangeCurrentFolder(AbstractFile folder, AbstractFile selectThisFileAfter, boolean findWorkableFolder) {
        LOGGER.debug("folder=" + folder + " selectThisFileAfter=" + selectThisFileAfter);
        Object object = this.FOLDER_CHANGE_LOCK;
        synchronized (object) {
            if (this.changeFolderThread != null) {
                LOGGER.debug("A folder change is already taking place (" + this.changeFolderThread + "), returning null");
                return null;
            }
            ChangeFolderThread thread = new ChangeFolderThread(folder, findWorkableFolder);
            if (selectThisFileAfter != null) {
                thread.selectThisFileAfter(selectThisFileAfter);
            }
            thread.start();
            this.changeFolderThread = thread;
            return thread;
        }
    }

    public ChangeFolderThread tryChangeCurrentFolder(String folderPath) {
        try {
            return this.tryChangeCurrentFolder(FileURL.getFileURL(folderPath), null);
        }
        catch (MalformedURLException e) {
            this.showFolderDoesNotExistDialog();
            return null;
        }
    }

    public ChangeFolderThread tryChangeCurrentFolder(FileURL folderURL) {
        return this.tryChangeCurrentFolder(folderURL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeFolderThread tryChangeCurrentFolder(FileURL folderURL, CredentialsMapping credentialsMapping) {
        LOGGER.debug("folderURL=" + folderURL);
        Object object = this.FOLDER_CHANGE_LOCK;
        synchronized (object) {
            if (this.changeFolderThread != null) {
                LOGGER.debug("A folder change is already taking place (" + this.changeFolderThread + "), returning null");
                return null;
            }
            ChangeFolderThread thread = new ChangeFolderThread(folderURL);
            thread.setCredentialsMapping(credentialsMapping);
            thread.start();
            this.changeFolderThread = thread;
            return thread;
        }
    }

    public ChangeFolderThread tryRefreshCurrentFolder() {
        return this.tryRefreshCurrentFolder(null);
    }

    public ChangeFolderThread tryRefreshCurrentFolder(AbstractFile selectThisFileAfter) {
        this.foldersTreePanel.refreshFolder(this.currentFolder);
        return this.tryChangeCurrentFolder(this.currentFolder, selectThisFileAfter, true);
    }

    private void setCurrentFolder(AbstractFile folder, AbstractFile[] children, AbstractFile fileToSelect) {
        this.lastFolderChangeTime = System.currentTimeMillis();
        if (fileToSelect == null) {
            this.fileTable.setCurrentFolder(folder, children);
        } else {
            this.fileTable.setCurrentFolder(folder, children, fileToSelect);
        }
        this.currentFolder = folder;
        this.folderHistory.addToHistory(folder);
        this.locationManager.fireLocationChanged(folder.getURL());
    }

    public long getLastFolderChangeTime() {
        return this.lastFolderChangeTime;
    }

    public ChangeFolderThread getChangeFolderThread() {
        return this.changeFolderThread;
    }

    public FolderChangeMonitor getFolderChangeMonitor() {
        return this.folderChangeMonitor;
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + " currentFolder=" + this.currentFolder + " hasFocus=" + this.hasFocus();
    }

    public void focusGained(FocusEvent e) {
        this.mainFrame.setActiveTable(this.fileTable);
    }

    public void focusLost(FocusEvent e) {
        this.fileTable.getQuickSearch().stop();
    }

    public void showQuickList(int index) {
        this.fileTablePopups[index].show(this);
    }

    public boolean isTreeVisible() {
        return this.treeVisible;
    }

    public int getTreeWidth() {
        if (!this.treeVisible) {
            return this.oldTreeWidth;
        }
        return this.treeSplitPane.getDividerLocation();
    }

    public void setTreeWidth(int width) {
        if (!this.treeVisible) {
            this.oldTreeWidth = width;
        } else {
            this.treeSplitPane.setDividerLocation(width);
            this.treeSplitPane.doLayout();
        }
    }

    public FoldersTreePanel getFoldersTreePanel() {
        return this.foldersTreePanel;
    }

    public void setTreeVisible(boolean treeVisible) {
        if (this.treeVisible != treeVisible) {
            this.treeVisible = treeVisible;
            if (!treeVisible) {
                this.oldTreeWidth = this.treeSplitPane.getDividerLocation();
            }
            this.foldersTreePanel.setVisible(treeVisible);
            this.treeSplitPane.setDividerLocation(treeVisible ? this.oldTreeWidth : 0);
            this.treeSplitPane.setDividerSize(treeVisible ? 5 : 0);
            this.foldersTreePanel.requestFocus();
        }
    }

    public class ChangeFolderThread
    extends Thread {
        private AbstractFile folder;
        private boolean findWorkableFolder;
        private FileURL folderURL;
        private AbstractFile fileToSelect;
        private CredentialsMapping credentialsMapping;
        private boolean killed;
        private boolean killedByInterrupt;
        private boolean killedByStop;
        private boolean doNotKill;
        private boolean disposed;
        private final Object KILL_LOCK = new Object();

        public ChangeFolderThread(AbstractFile folder, boolean findWorkableFolder) {
            this.folder = folder instanceof CachedFile ? ((CachedFile)folder).getProxiedFile() : folder;
            this.folderURL = folder.getURL();
            this.findWorkableFolder = findWorkableFolder;
            this.setPriority(10);
        }

        public ChangeFolderThread(FileURL folderURL) {
            this.folderURL = folderURL;
            this.setPriority(10);
        }

        public void selectThisFileAfter(AbstractFile fileToSelect) {
            this.fileToSelect = fileToSelect;
        }

        public void setCredentialsMapping(CredentialsMapping credentialsMapping) {
            this.credentialsMapping = credentialsMapping;
        }

        private AbstractFile getWorkableFolder(AbstractFile folder) {
            AbstractFile[] localVolumes;
            AbstractFile newFolder = folder;
            do {
                if ((newFolder = newFolder.getParent()) == null || !newFolder.exists()) continue;
                return newFolder;
            } while (newFolder != null);
            for (AbstractFile volume : localVolumes = LocalFile.getVolumes()) {
                if (!volume.exists()) continue;
                return volume;
            }
            return null;
        }

        private boolean followCanonicalPath(AbstractFile file) {
            return (MuConfigurations.getPreferences().getVariable(MuPreference.CD_FOLLOWS_SYMLINKS, false) || file.getURL().getScheme().equals("http")) && !file.getAbsolutePath(false).equals(file.getCanonicalPath(false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryKill() {
            Object object = this.KILL_LOCK;
            synchronized (object) {
                if (this.killedByStop) {
                    LOGGER.debug("Thread already killed by #interrupt() and #stop(), there's nothing we can do, returning");
                    return false;
                }
                if (this.doNotKill) {
                    LOGGER.debug("Can't kill thread now, it's too late, returning");
                    return false;
                }
                this.killed = true;
                if (!this.killedByInterrupt) {
                    LOGGER.debug("Killing thread using #interrupt()");
                    this.killedByInterrupt = true;
                    this.interrupt();
                } else {
                    LOGGER.debug("Killing thread using #stop()");
                    this.killedByStop = true;
                    super.stop();
                    this.cleanup(false);
                }
                return true;
            }
        }

        public void start() {
            FolderPanel.this.locationManager.fireLocationChanging(this.folder == null ? this.folderURL : this.folder.getURL());
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOGGER.debug("starting folder change...");
            boolean folderChangedSuccessfully = false;
            FolderPanel.this.locationTextField.setProgressValue(10);
            boolean userCancelled = false;
            CredentialsMapping newCredentialsMapping = null;
            boolean guestCredentialsSelected = false;
            AuthenticationType authenticationType = this.folderURL.getAuthenticationType();
            if (this.credentialsMapping != null) {
                newCredentialsMapping = this.credentialsMapping;
                CredentialsManager.authenticate(this.folderURL, newCredentialsMapping);
            } else if (!this.folderURL.containsCredentials() && (authenticationType == AuthenticationType.AUTHENTICATION_REQUIRED || authenticationType == AuthenticationType.AUTHENTICATION_OPTIONAL && CredentialsManager.getMatchingCredentials(this.folderURL).length > 0)) {
                AuthDialog authDialog = FolderPanel.this.popAuthDialog(this.folderURL, false, null);
                newCredentialsMapping = authDialog.getCredentialsMapping();
                guestCredentialsSelected = authDialog.guestCredentialsSelected();
                if (newCredentialsMapping == null) {
                    userCancelled = true;
                } else {
                    CredentialsManager.authenticate(this.folderURL, newCredentialsMapping);
                    this.folder = null;
                }
            }
            if (!userCancelled) {
                boolean canonicalPathFollowed = false;
                while (true) {
                    FolderPanel.this.mainFrame.setCursor(new Cursor(3));
                    FolderPanel.this.mainFrame.setNoEventsMode(true);
                    try {
                        Object dialog;
                        if (this.folder == null) {
                            AbstractFile file = FileFactory.getFile(this.folderURL, true);
                            Object object = this.KILL_LOCK;
                            synchronized (object) {
                                if (this.killed) {
                                    LOGGER.debug("this thread has been killed, returning");
                                    break;
                                }
                            }
                            FolderPanel.this.locationTextField.setProgressValue(25);
                            if (file == null || !file.exists()) {
                                FolderPanel.this.mainFrame.setCursor(Cursor.getDefaultCursor());
                                FolderPanel.this.showFolderDoesNotExistDialog();
                                break;
                            }
                            if (!file.isDirectory()) {
                                if (file.isBrowsable()) {
                                    if (!FolderPanel.this.folderHistory.historyContains(this.folderURL) && !file.equals(FolderPanel.this.fileTable.getSelectedFile())) {
                                        FolderPanel.this.mainFrame.setCursor(Cursor.getDefaultCursor());
                                        dialog = new QuestionDialog(FolderPanel.this.mainFrame, null, Translator.get("table.download_or_browse", new String[0]), (Component)FolderPanel.this.mainFrame, new String[]{BROWSE_TEXT, DOWNLOAD_TEXT, CANCEL_TEXT}, new int[]{1, 2, 0}, 0);
                                        int ret = ((QuestionDialog)dialog).getActionValue();
                                        if (ret == -1 || ret == 0) break;
                                        if (ret == 2) {
                                            FolderPanel.this.showDownloadDialog(file);
                                            break;
                                        }
                                        FolderPanel.this.mainFrame.setCursor(new Cursor(3));
                                    }
                                } else {
                                    FolderPanel.this.showDownloadDialog(file);
                                    break;
                                }
                            }
                            this.folder = file;
                        } else if (!this.folder.exists()) {
                            if (this.findWorkableFolder) {
                                AbstractFile newFolder = this.getWorkableFolder(this.folder);
                                if (newFolder.equals(this.folder)) {
                                    FolderPanel.this.showFolderDoesNotExistDialog();
                                    break;
                                }
                                this.folder = newFolder;
                                this.folderURL = this.folder.getURL();
                                this.fileToSelect = null;
                                continue;
                            }
                            FolderPanel.this.showFolderDoesNotExistDialog();
                            break;
                        }
                        if (!canonicalPathFollowed && this.followCanonicalPath(this.folder)) {
                            try {
                                FileURL newURL = FileURL.getFileURL(this.folder.getCanonicalPath());
                                newURL.setCredentials(this.folderURL.getCredentials());
                                newURL.importProperties(this.folderURL);
                                this.folderURL = newURL;
                                this.folder = null;
                                canonicalPathFollowed = true;
                                continue;
                            }
                            catch (MalformedURLException e) {
                                // empty catch block
                            }
                        }
                        Object e = this.KILL_LOCK;
                        synchronized (e) {
                            if (this.killed) {
                                LOGGER.debug("this thread has been killed, returning");
                                break;
                            }
                        }
                        FolderPanel.this.locationTextField.setProgressValue(50);
                        LOGGER.trace("calling ls()");
                        AbstractFile[] children = this.folder.ls(FolderPanel.this.configurableFolderFilter);
                        dialog = this.KILL_LOCK;
                        synchronized (dialog) {
                            if (this.killed) {
                                LOGGER.debug("this thread has been killed, returning");
                                break;
                            }
                            this.doNotKill = true;
                        }
                        FolderPanel.this.locationTextField.setProgressValue(75);
                        LOGGER.trace("calling setCurrentFolder");
                        FolderPanel.this.setCurrentFolder(this.folder, children, this.fileToSelect);
                        FolderPanel.this.locationTextField.setProgressValue(95);
                        if (newCredentialsMapping != null && !guestCredentialsSelected) {
                            CredentialsManager.addCredentials(newCredentialsMapping);
                        }
                        folderChangedSuccessfully = true;
                    }
                    catch (Exception e) {
                        LOGGER.debug("Caught exception", e);
                        if (this.killed) {
                            LOGGER.debug("Thread was interrupted, ignoring exception");
                            break;
                        }
                        FolderPanel.this.mainFrame.setCursor(Cursor.getDefaultCursor());
                        if (e instanceof AuthException) {
                            AuthException authException = (AuthException)e;
                            AuthDialog authDialog = FolderPanel.this.popAuthDialog(authException.getURL(), true, authException.getMessage());
                            newCredentialsMapping = authDialog.getCredentialsMapping();
                            guestCredentialsSelected = authDialog.guestCredentialsSelected();
                            if (newCredentialsMapping == null) break;
                            this.folder = null;
                            CredentialsManager.authenticate(this.folderURL, newCredentialsMapping);
                            continue;
                        }
                        if (this.findWorkableFolder) {
                            AbstractFile newFolder = this.getWorkableFolder(this.folder);
                            if (newFolder.equals(this.folder)) {
                                FolderPanel.this.showFolderDoesNotExistDialog();
                                break;
                            }
                            this.folder = newFolder;
                            this.folderURL = this.folder.getURL();
                            this.fileToSelect = null;
                            continue;
                        }
                        FolderPanel.this.showAccessErrorDialog(e);
                    }
                    break;
                }
            }
            Object object = this.KILL_LOCK;
            synchronized (object) {
                this.cleanup(folderChangedSuccessfully);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup(boolean folderChangedSuccessfully) {
            Object object = this.KILL_LOCK;
            synchronized (object) {
                if (this.disposed) {
                    LOGGER.debug("already called, returning");
                    return;
                }
                this.disposed = true;
            }
            LOGGER.trace("cleaning up, folderChangedSuccessfully=" + folderChangedSuccessfully);
            ChangeFolderThread.interrupted();
            FolderPanel.this.locationTextField.setProgressValue(0);
            FolderPanel.this.mainFrame.setCursor(Cursor.getDefaultCursor());
            object = FolderPanel.this.FOLDER_CHANGE_LOCK;
            synchronized (object) {
                FolderPanel.this.changeFolderThread = null;
            }
            FolderPanel.this.mainFrame.setNoEventsMode(false);
            if (!folderChangedSuccessfully) {
                FileURL failedURL;
                FileURL fileURL = failedURL = this.folder == null ? this.folderURL : this.folder.getURL();
                if (this.killed) {
                    FolderPanel.this.locationManager.fireLocationCancelled(failedURL);
                } else {
                    FolderPanel.this.locationManager.fireLocationFailed(failedURL);
                }
            }
        }

        public String toString() {
            return super.toString() + " folderURL=" + this.folderURL + " folder=" + this.folder;
        }
    }
}

