/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.ui.main.FolderPanel;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocationHistory.class);
    private List<FileURL> history = new Vector<FileURL>(101);
    private int historyIndex = -1;
    private FolderPanel folderPanel;
    private String lastRecallableFolder;

    public LocationHistory(FolderPanel folderPanel) {
        this.folderPanel = folderPanel;
    }

    void addToHistory(AbstractFile folder) {
        int historySize = this.history.size();
        FileURL folderURL = folder.getURL();
        if (this.historyIndex < 0 || !folderURL.equals(this.history.get(this.historyIndex), false, false)) {
            ++this.historyIndex;
            for (int i = this.historyIndex; i < historySize; ++i) {
                this.history.remove(this.historyIndex);
            }
            if (this.history.size() >= 100) {
                this.history.remove(0);
                --this.historyIndex;
            }
            this.history.add(folderURL);
        }
        LOGGER.trace("folder=" + folder + " root=" + folder.getRoot());
        if (folderURL.getScheme().equals("file") && folder.isDirectory() && folder instanceof LocalFile && !((LocalFile)folder.getRoot()).guessRemovableDrive()) {
            this.lastRecallableFolder = folder.getAbsolutePath();
            LOGGER.trace("lastRecallableFolder= " + this.lastRecallableFolder);
        }
    }

    public synchronized void goBack() {
        if (this.historyIndex == 0) {
            return;
        }
        this.folderPanel.tryChangeCurrentFolder(this.history.get(--this.historyIndex));
    }

    public synchronized void goForward() {
        if (this.historyIndex == this.history.size() - 1) {
            return;
        }
        this.folderPanel.tryChangeCurrentFolder(this.history.get(++this.historyIndex));
    }

    public boolean hasBackFolder() {
        return this.historyIndex > 0;
    }

    public boolean hasForwardFolder() {
        return this.historyIndex != this.history.size() - 1;
    }

    public FileURL[] getBackFolders() {
        if (!this.hasBackFolder()) {
            return new FileURL[0];
        }
        int backLen = this.historyIndex;
        FileURL[] urls = new FileURL[backLen];
        int cur = 0;
        for (int i = this.historyIndex - 1; i >= 0; --i) {
            urls[cur++] = this.history.get(i);
        }
        return urls;
    }

    public FileURL[] getForwardFolders() {
        if (!this.hasForwardFolder()) {
            return new FileURL[0];
        }
        int historySize = this.history.size();
        FileURL[] urls = new FileURL[historySize - this.historyIndex - 1];
        int cur = 0;
        for (int i = this.historyIndex + 1; i < historySize; ++i) {
            urls[cur++] = this.history.get(i);
        }
        return urls;
    }

    public boolean historyContains(FileURL folderURL) {
        return this.history.contains(folderURL);
    }
}

