/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main;

import com.mucommander.commons.file.util.ResourceLoader;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.icon.IconManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow {
    private String version;
    private String loadingMessage;
    private Font customFont;
    private static final String SPLASH_IMAGE_PATH = IconManager.getIconSetFolder(7) + "splash.png";
    private static final Color TEXT_COLOR = new Color(192, 238, 241);
    private static final Color SHADOW_TEXT_COLOR = new Color(0, 86, 117);

    public SplashScreen(String version, String loadingMessage) {
        this.version = version;
        this.loadingMessage = loadingMessage;
        this.customFont = new Font("Courier", 1, 11);
        ImageIcon imageIcon = new ImageIcon(ResourceLoader.getResourceAsURL(SPLASH_IMAGE_PATH));
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(imageIcon.getImage(), 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.setContentPane(new JLabel(imageIcon));
        int width = imageIcon.getIconWidth();
        int height = imageIcon.getIconHeight();
        this.setSize(width, height);
        DialogToolkit.centerOnScreen(this);
        this.setVisible(true);
    }

    public void setLoadingMessage(String msg) {
        this.loadingMessage = msg;
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setFont(this.customFont);
        int textX = 4;
        int textY = this.getHeight() - 6;
        g.setColor(SHADOW_TEXT_COLOR);
        g.drawString(this.loadingMessage, textX - 1, textY - 1);
        g.setColor(TEXT_COLOR);
        g.drawString(this.loadingMessage, textX, textY);
        FontRenderContext fontRenderContext = ((Graphics2D)g).getFontRenderContext();
        Rectangle2D textBounds = new TextLayout(this.version, this.customFont, fontRenderContext).getBounds();
        textX = this.getWidth() - (int)textBounds.getWidth() - 5;
        textY = (int)textBounds.getHeight() + 3;
        g.setColor(SHADOW_TEXT_COLOR);
        g.drawString(this.version, textX - 1, textY - 1);
        g.setColor(TEXT_COLOR);
        g.drawString(this.version, textX, textY);
    }
}

