/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main;

import com.mucommander.ShutdownHook;
import com.mucommander.auth.CredentialsManager;
import com.mucommander.auth.CredentialsMapping;
import com.mucommander.commons.conf.Configuration;
import com.mucommander.commons.conf.ConfigurationEvent;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.commons.conf.ValueList;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileURL;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.conf.MuPreferencesAPI;
import com.mucommander.conf.MuSnapshot;
import com.mucommander.extension.ExtensionManager;
import com.mucommander.ui.dialog.auth.AuthDialog;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.commandbar.CommandBar;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowManager
implements ConfigurationListener,
WindowListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowManager.class);
    private static List<MainFrame> mainFrames = new Vector<MainFrame>();
    private static MainFrame currentMainFrame;
    private static WindowManager instance;

    private static void installCustomLookAndFeels() {
        ValueList plafs = MuConfigurations.getPreferences().getListVariable(MuPreference.CUSTOM_LOOK_AND_FEELS, ";");
        if (plafs == null) {
            return;
        }
        for (String plaf : plafs) {
            try {
                WindowManager.installLookAndFeel(plaf);
            }
            catch (Throwable e) {
                LOGGER.info("Failed to install Look&Feel " + plaf, e);
            }
        }
    }

    private WindowManager() {
        MuConfigurations.addPreferencesListener(this);
    }

    private static AbstractFile[] getInitialPaths(int frame) {
        AbstractFile[] abstractFileArray;
        String[] folderPaths;
        Configuration snapshot = MuConfigurations.getSnapshot();
        MuPreferencesAPI preferences = MuConfigurations.getPreferences();
        boolean isCustom = (frame == 0 ? preferences.getVariable(MuPreference.LEFT_STARTUP_FOLDER, "lastFolder") : preferences.getVariable(MuPreference.RIGHT_STARTUP_FOLDER, "lastFolder")).equals("customFolder");
        if (isCustom) {
            folderPaths = new String[]{frame == 0 ? preferences.getVariable(MuPreference.LEFT_CUSTOM_FOLDER) : preferences.getVariable(MuPreference.RIGHT_CUSTOM_FOLDER)};
        } else {
            int indexOfPreviouslySelectedWindow = MuConfigurations.getSnapshot().getIntegerVariable(MuSnapshot.getSelectedWindow());
            int nbFolderPaths = snapshot.getVariable(MuSnapshot.getTabsCountVariable(indexOfPreviouslySelectedWindow, frame == 0), 0);
            folderPaths = new String[nbFolderPaths];
            for (int i = 0; i < nbFolderPaths; ++i) {
                folderPaths[i] = snapshot.getVariable(MuSnapshot.getTabLocationVariable(indexOfPreviouslySelectedWindow, frame == 0, i));
            }
        }
        LinkedList<AbstractFile> initialFolders = new LinkedList<AbstractFile>();
        for (String folderPath : folderPaths) {
            AbstractFile folder;
            if (folderPath == null || (folder = FileFactory.getFile(folderPath)) == null || !folder.exists()) continue;
            initialFolders.add(folder);
        }
        if (initialFolders.size() == 0) {
            AbstractFile[] abstractFileArray2 = new AbstractFile[1];
            abstractFileArray = abstractFileArray2;
            abstractFileArray2[0] = FileFactory.getFile(System.getProperty("user.home"));
        } else {
            abstractFileArray = initialFolders.toArray(new AbstractFile[0]);
        }
        AbstractFile[] results = abstractFileArray;
        LOGGER.debug("initial folders:");
        for (AbstractFile result : results) {
            LOGGER.debug("\t" + result);
        }
        return results;
    }

    private static AbstractFile[] getInitialAbstractPaths(String path, int frame) {
        AbstractFile file;
        if (path == null) {
            return WindowManager.getInitialPaths(frame);
        }
        while (true) {
            try {
                file = FileFactory.getFile(path, true);
                if (!file.exists()) {
                    file = null;
                }
            }
            catch (Exception e) {
                if (e instanceof AuthException) {
                    AuthException authException = (AuthException)e;
                    FileURL url = authException.getURL();
                    AuthDialog authDialog = new AuthDialog(currentMainFrame, url, true, authException.getMessage());
                    authDialog.showDialog();
                    CredentialsMapping newCredentialsMapping = authDialog.getCredentialsMapping();
                    if (newCredentialsMapping != null) {
                        CredentialsManager.authenticate(url, newCredentialsMapping);
                        path = url.toString(true);
                        continue;
                    }
                    return WindowManager.getInitialPaths(frame);
                }
                file = null;
            }
            break;
        }
        if (!(file != null || (file = FileFactory.getFile(new File(path).getAbsolutePath())) != null && file.exists())) {
            return WindowManager.getInitialPaths(frame);
        }
        if (!file.isBrowsable() && (file = file.getParent()) == null) {
            return WindowManager.getInitialPaths(frame);
        }
        return new AbstractFile[]{file};
    }

    public static WindowManager getInstance() {
        return instance;
    }

    public static MainFrame getCurrentMainFrame() {
        return currentMainFrame;
    }

    public static List<MainFrame> getMainFrames() {
        return mainFrames;
    }

    public static void tryRefreshCurrentFolders() {
        currentMainFrame.tryRefreshCurrentFolders();
        for (MainFrame mainFrame : mainFrames) {
            if (mainFrame == currentMainFrame) continue;
            mainFrame.tryRefreshCurrentFolders();
        }
    }

    public static synchronized MainFrame createNewMainFrame() {
        if (currentMainFrame == null) {
            return WindowManager.createNewMainFrame(WindowManager.getInitialPaths(0), WindowManager.getInitialPaths(1));
        }
        return WindowManager.createNewMainFrame(new AbstractFile[]{currentMainFrame.getLeftPanel().getFileTable().getCurrentFolder()}, new AbstractFile[]{currentMainFrame.getRightPanel().getFileTable().getCurrentFolder()});
    }

    public static synchronized MainFrame createNewMainFrame(String folder1, String folder2) {
        return WindowManager.createNewMainFrame(WindowManager.getInitialAbstractPaths(folder1, 0), WindowManager.getInitialAbstractPaths(folder2, 1));
    }

    public static synchronized MainFrame createNewMainFrame(AbstractFile[] leftFolders, AbstractFile[] rightFolders) {
        int height;
        int width;
        int y;
        int x;
        MainFrame newMainFrame = currentMainFrame == null ? new MainFrame(leftFolders, rightFolders) : currentMainFrame.cloneMainFrame();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (mainFrames.isEmpty()) {
            currentMainFrame = newMainFrame;
            x = MuConfigurations.getSnapshot().getIntegerVariable(MuSnapshot.getX(0));
            y = MuConfigurations.getSnapshot().getIntegerVariable(MuSnapshot.getY(0));
            width = MuConfigurations.getSnapshot().getIntegerVariable(MuSnapshot.getWidth(0));
            height = MuConfigurations.getSnapshot().getIntegerVariable(MuSnapshot.getHeight(0));
            int lastScreenWidth = MuConfigurations.getSnapshot().getIntegerVariable("screen.width");
            int lastScreenHeight = MuConfigurations.getSnapshot().getIntegerVariable("screen.height");
            if (x == -1 || y == -1 || width == -1 || height == -1 || screenSize.width != lastScreenWidth || screenSize.height != lastScreenHeight || width + x > screenSize.width + 5 || height + y > screenSize.height + 5) {
                x = screenSize.width / 10;
                y = screenSize.height / 10;
                width = (int)((double)screenSize.width * 0.8);
                height = (int)((double)screenSize.height * 0.8);
            }
        } else {
            x = currentMainFrame.getX() + 22;
            y = currentMainFrame.getY() + 22;
            width = currentMainFrame.getWidth();
            height = currentMainFrame.getHeight();
            if (!WindowManager.isInsideUsableScreen(currentMainFrame, x + width, -1)) {
                x = 0;
            }
            if (!WindowManager.isInsideUsableScreen(currentMainFrame, -1, y + height)) {
                y = 0;
            }
            if (width + x > screenSize.width) {
                width = screenSize.width - x;
            }
            if (height + y > screenSize.height) {
                height = screenSize.height - y;
            }
        }
        newMainFrame.setBounds(new Rectangle(x, y, width, height));
        newMainFrame.addWindowListener(instance);
        mainFrames.add(newMainFrame);
        newMainFrame.updateWindowTitle();
        if (mainFrames.size() == 2) {
            mainFrames.get(0).updateWindowTitle();
        }
        newMainFrame.setVisible(true);
        return newMainFrame;
    }

    public static synchronized void quit() {
        int nbFrames = mainFrames.size();
        if (nbFrames > 0) {
            int currentMainFrameIndex = WindowManager.getCurrentWindowIndex();
            for (int i = 0; i < nbFrames; ++i) {
                if (i == currentMainFrameIndex) continue;
                mainFrames.get(i).dispose();
            }
            mainFrames.get(currentMainFrameIndex).dispose();
        }
        Frame[] frames = Frame.getFrames();
        nbFrames = frames.length;
        for (int i = 0; i < nbFrames; ++i) {
            Frame frame = frames[i];
            if (!frame.isShowing()) continue;
            LOGGER.debug("disposing frame#" + i);
            frame.dispose();
        }
        ShutdownHook.initiateShutdown();
    }

    public static int getCurrentWindowIndex() {
        return mainFrames.indexOf(currentMainFrame);
    }

    public static void switchToNextWindow() {
        int frameIndex = WindowManager.getCurrentWindowIndex();
        MainFrame mainFrame = mainFrames.get(frameIndex == mainFrames.size() - 1 ? 0 : frameIndex + 1);
        mainFrame.toFront();
    }

    public static void switchToPreviousWindow() {
        int frameIndex = WindowManager.getCurrentWindowIndex();
        MainFrame mainFrame = mainFrames.get(frameIndex == 0 ? mainFrames.size() - 1 : frameIndex - 1);
        mainFrame.toFront();
    }

    public static void installLookAndFeel(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        LookAndFeel plaf = (LookAndFeel)Class.forName(className, true, ExtensionManager.getClassLoader()).newInstance();
        if (plaf.isSupportedLookAndFeel()) {
            UIManager.installLookAndFeel(plaf.getName(), plaf.getClass().getName());
        }
    }

    private static void setLookAndFeel(String lnfName) {
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader oldLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(ExtensionManager.getClassLoader());
            UIManager.setLookAndFeel((LookAndFeel)Class.forName(lnfName, true, ExtensionManager.getClassLoader()).newInstance());
            currentThread.setContextClassLoader(oldLoader);
            for (int i = 0; i < mainFrames.size(); ++i) {
                SwingUtilities.updateComponentTreeUI(mainFrames.get(i));
            }
        }
        catch (Throwable e) {
            LOGGER.debug("Exception caught", e);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
        Object source = e.getSource();
        if (!(source instanceof MainFrame)) {
            return;
        }
        currentMainFrame = (MainFrame)e.getSource();
        currentMainFrame.setForegroundActive(true);
        CommandBar commandBar = currentMainFrame.getCommandBar();
        if (commandBar != null) {
            commandBar.setAlternateActionsMode(false);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        Object source = e.getSource();
        MenuSelectionManager.defaultManager().clearSelectedPath();
        if (!(source instanceof MainFrame)) {
            return;
        }
        ((MainFrame)e.getSource()).setForegroundActive(false);
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public synchronized void windowClosed(WindowEvent e) {
        int nbFrames;
        LOGGER.trace("called");
        Object source = e.getSource();
        if (source instanceof MainFrame) {
            int frameIndex = mainFrames.indexOf(source);
            mainFrames.remove(source);
            nbFrames = mainFrames.size();
            if (nbFrames == 1) {
                mainFrames.get(0).updateWindowTitle();
            } else if (frameIndex != -1) {
                for (int i = frameIndex; i < nbFrames; ++i) {
                    mainFrames.get(i).updateWindowTitle();
                }
            }
        }
        if (mainFrames.size() > 0) {
            return;
        }
        Frame[] frames = Frame.getFrames();
        nbFrames = frames.length;
        for (int i = 0; i < nbFrames; ++i) {
            Frame frame = frames[i];
            if (!frame.isShowing()) continue;
            LOGGER.debug("found active frame#" + i);
            return;
        }
        ShutdownHook.initiateShutdown();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void configurationChanged(ConfigurationEvent event) {
        String var = event.getVariable();
        if (var.equals("lookAndFeel")) {
            String lnfName = event.getValue();
            if (!UIManager.getLookAndFeel().getClass().getName().equals(lnfName)) {
                WindowManager.setLookAndFeel(lnfName);
            }
        }
    }

    public static Insets getScreenInsets(Window window) {
        return Toolkit.getDefaultToolkit().getScreenInsets(window.getGraphicsConfiguration());
    }

    public static boolean isInsideUsableScreen(Frame frame, int x, int y) {
        Insets screenInsets = WindowManager.getScreenInsets(frame);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return (x < 0 || x >= screenInsets.left && x < screenSize.width - screenInsets.right) && (y < 0 || y >= screenInsets.top && y < screenSize.height - screenInsets.bottom);
    }

    public static Rectangle getFullScreenBounds(Window window) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Insets screenInsets = toolkit.getScreenInsets(window.getGraphicsConfiguration());
        return new Rectangle(screenInsets.left, screenInsets.top, screenSize.width - screenInsets.left - screenInsets.right, screenSize.height - screenInsets.top - screenInsets.bottom);
    }

    static {
        instance = new WindowManager();
        UIManager.getDefaults().put("ClassLoader", ExtensionManager.getClassLoader());
        WindowManager.installCustomLookAndFeels();
        String string = MuConfigurations.getPreferences().getVariable(MuPreference.LOOK_AND_FEEL);
        if (string != null && !string.equals(UIManager.getLookAndFeel().getName())) {
            WindowManager.setLookAndFeel(string);
        }
        if (string == null) {
            LOGGER.debug("Could load look'n feel from preferences");
        }
    }
}

