/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.commandbar;

import com.mucommander.desktop.DesktopManager;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.commandbar.CommandBarAttributes;
import com.mucommander.ui.main.commandbar.CommandBarAttributesListener;
import com.mucommander.ui.main.commandbar.CommandBarButton;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class CommandBar
extends JPanel
implements CommandBarAttributesListener,
KeyListener,
MouseListener {
    private MainFrame mainFrame;
    private boolean modifierDown;
    private CommandBarButton[] buttons;
    private static String[] actionIds;
    private static String[] alternateActionIds;
    private static KeyStroke modifier;

    public CommandBar(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        mainFrame.getLeftPanel().getFileTable().addKeyListener(this);
        mainFrame.getRightPanel().getFileTable().addKeyListener(this);
        this.addMouseListener(this);
        actionIds = CommandBarAttributes.getActions();
        alternateActionIds = CommandBarAttributes.getAlternateActions();
        modifier = CommandBarAttributes.getModifier();
        this.addButtons();
        CommandBarAttributes.addCommandBarAttributesListener(this);
    }

    private void addButtons() {
        this.setLayout(new GridLayout(0, actionIds.length));
        int nbButtons = actionIds.length;
        this.buttons = new CommandBarButton[nbButtons];
        for (int i = 0; i < nbButtons; ++i) {
            this.buttons[i] = CommandBarButton.create(actionIds[i], this.mainFrame);
            this.buttons[i].addMouseListener(this);
            this.add(this.buttons[i]);
        }
    }

    public void setAlternateActionsMode(boolean on) {
        if (!this.isVisible()) {
            return;
        }
        if (this.modifierDown != on) {
            this.modifierDown = on;
            int nbButtons = this.buttons.length;
            for (int i = 0; i < nbButtons; ++i) {
                this.buttons[i].setButtonAction(on && alternateActionIds[i] != null ? alternateActionIds[i] : actionIds[i], this.mainFrame);
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == modifier.getKeyCode()) {
            this.setAlternateActionsMode(true);
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == modifier.getKeyCode()) {
            this.setAlternateActionsMode(false);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (DesktopManager.isRightMouseButton(e)) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(ActionManager.getActionInstance("ToggleCommandBar", this.mainFrame));
            popupMenu.add(ActionManager.getActionInstance("CustomizeCommandBar", this.mainFrame));
            Point clickLocation = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this);
            popupMenu.show(this, clickLocation.x, clickLocation.y);
            popupMenu.setVisible(true);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void commandBarAttributeChanged() {
        actionIds = CommandBarAttributes.getActions();
        alternateActionIds = CommandBarAttributes.getAlternateActions();
        modifier = CommandBarAttributes.getModifier();
        this.removeAll();
        this.addButtons();
        this.doLayout();
    }
}

