/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.commandbar;

import com.mucommander.ui.main.commandbar.CommandBarAttributesListener;
import java.util.WeakHashMap;
import javax.swing.KeyStroke;

public class CommandBarAttributes {
    private static String[] actionIds;
    private static String[] alternateActionIds;
    private static KeyStroke modifier;
    private static final String[] DEFAULT_ACTION_IDS;
    private static final String[] DEFAULT_ALTERNATE_ACTION_IDS;
    private static KeyStroke DEFAULT_MODIFIER;
    private static WeakHashMap<CommandBarAttributesListener, ?> listeners;

    public static void restoreDefault() {
        CommandBarAttributes.setAttributes(DEFAULT_ACTION_IDS, DEFAULT_ALTERNATE_ACTION_IDS, DEFAULT_MODIFIER);
    }

    public static boolean areDefaultAttributes() {
        int i;
        if (actionIds != DEFAULT_ACTION_IDS) {
            int nbActions = actionIds.length;
            if (nbActions != DEFAULT_ACTION_IDS.length) {
                return false;
            }
            for (i = 0; i < nbActions; ++i) {
                if (CommandBarAttributes.equals(actionIds[i], DEFAULT_ACTION_IDS[i])) continue;
                return false;
            }
        }
        if (alternateActionIds != DEFAULT_ALTERNATE_ACTION_IDS) {
            int nbAlternateActions = alternateActionIds.length;
            if (nbAlternateActions != DEFAULT_ALTERNATE_ACTION_IDS.length) {
                return false;
            }
            for (i = 0; i < nbAlternateActions; ++i) {
                if (CommandBarAttributes.equals(alternateActionIds[i], DEFAULT_ALTERNATE_ACTION_IDS[i])) continue;
                return false;
            }
        }
        return DEFAULT_MODIFIER == modifier || DEFAULT_MODIFIER.equals(modifier);
    }

    private static boolean equals(Object action1, Object action2) {
        if (action1 == null) {
            return action2 == null;
        }
        return action1.equals(action2);
    }

    public static void setAttributes(String[] actionIds, String[] alternateActionIds, KeyStroke modifier) {
        CommandBarAttributes.actionIds = actionIds;
        CommandBarAttributes.alternateActionIds = alternateActionIds;
        CommandBarAttributes.modifier = modifier;
        CommandBarAttributes.fireAttributesChanged();
    }

    public static String[] getActions() {
        return actionIds;
    }

    public static String[] getAlternateActions() {
        return alternateActionIds;
    }

    public static KeyStroke getModifier() {
        return modifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCommandBarAttributesListener(CommandBarAttributesListener listener) {
        WeakHashMap<CommandBarAttributesListener, ?> weakHashMap = listeners;
        synchronized (weakHashMap) {
            listeners.put(listener, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireAttributesChanged() {
        WeakHashMap<CommandBarAttributesListener, ?> weakHashMap = listeners;
        synchronized (weakHashMap) {
            for (CommandBarAttributesListener listener : listeners.keySet()) {
                listener.commandBarAttributeChanged();
            }
        }
    }

    static {
        DEFAULT_ACTION_IDS = new String[]{"View", "Edit", "Copy", "Move", "Mkdir", "Delete", "Refresh", "CloseWindow"};
        DEFAULT_ALTERNATE_ACTION_IDS = new String[]{null, null, "LocalCopy", "Rename", "Mkfile", "PermanentDelete", null, null};
        DEFAULT_MODIFIER = KeyStroke.getKeyStroke(16, 0);
        listeners = new WeakHashMap();
    }
}

