/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.commandbar;

import com.mucommander.commons.conf.ConfigurationEvent;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.button.NonFocusableButton;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.MainFrame;
import java.awt.Dimension;
import java.awt.Insets;

public class CommandBarButton
extends NonFocusableButton
implements ConfigurationListener {
    private String actionId;
    protected static float scaleFactor = Math.max(1.0f, MuConfigurations.getPreferences().getVariable(MuPreference.COMMAND_BAR_ICON_SCALE, 1.0f));

    public static CommandBarButton create(String actionId, MainFrame mainFrame) {
        return actionId == null ? null : new CommandBarButton(actionId, mainFrame);
    }

    protected CommandBarButton(String actionId, MainFrame mainFrame) {
        if (OsFamilies.MAC_OS_X.isCurrent() && OsVersions.MAC_OS_X_10_5.isCurrentOrHigher()) {
            this.putClientProperty("JComponent.sizeVariant", "small");
            this.putClientProperty("JButton.buttonType", "textured");
        } else {
            this.setMargin(new Insets(3, 4, 3, 4));
        }
        this.actionId = actionId;
        this.setButtonAction(actionId, mainFrame);
        this.setMinimumSize(new Dimension(40, (int)this.getPreferredSize().getHeight()));
        MuConfigurations.addPreferencesListener(this);
    }

    public void setButtonAction(String actionId, MainFrame mainFrame) {
        MuAction action = ActionManager.getActionInstance(actionId, mainFrame);
        this.setAction(action);
        String label = action.getLabel();
        if (action.getAcceleratorText() != null) {
            label = label + " [" + action.getAcceleratorText() + ']';
        }
        this.setText(label);
        if (scaleFactor != 1.0f) {
            this.setIcon(IconManager.getScaledIcon(action.getIcon(), scaleFactor));
        }
    }

    public String getActionId() {
        return this.actionId;
    }

    public void configurationChanged(ConfigurationEvent event) {
        String var = event.getVariable();
        if (var.equals("command_bar.icon_scale")) {
            scaleFactor = event.getFloatValue();
            this.setIcon(IconManager.getScaledIcon(((MuAction)this.getAction()).getIcon(), scaleFactor));
        }
    }
}

