/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.commandbar;

import com.mucommander.PlatformManager;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.ui.main.commandbar.CommandBarAttributes;
import com.mucommander.ui.main.commandbar.CommandBarReader;
import com.mucommander.ui.main.commandbar.CommandBarWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public abstract class CommandBarIO
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandBarIO.class);
    protected static AbstractFile commandBarFile;
    private static CommandBarWriter commandBarWriter;
    protected static boolean wasCommandBarModified;

    public static void loadCommandBar() throws Exception {
        AbstractFile commandBarFile = CommandBarIO.getDescriptionFile();
        if (commandBarFile != null && commandBarFile.exists()) {
            CommandBarReader reader = new CommandBarReader(commandBarFile);
            CommandBarAttributes.setAttributes(reader.getActionsRead(), reader.getAlternateActionsRead(), reader.getModifierRead());
        } else {
            CommandBarAttributes.restoreDefault();
            LOGGER.debug("command_bar.xml was not found, using defaults");
        }
        commandBarWriter = CommandBarWriter.create();
    }

    public static void setModified() {
        wasCommandBarModified = true;
    }

    public static void saveCommandBar() throws IOException {
        if (CommandBarAttributes.areDefaultAttributes()) {
            AbstractFile commandBarFile = CommandBarIO.getDescriptionFile();
            if (commandBarFile != null && commandBarFile.exists()) {
                LOGGER.info("Command bar use default settings, removing descriptor file");
                commandBarFile.delete();
            } else {
                LOGGER.debug("Command bar not modified, not saving");
            }
        } else if (commandBarWriter != null) {
            if (wasCommandBarModified) {
                commandBarWriter.write();
            } else {
                LOGGER.debug("Command bar not modified, not saving");
            }
        } else {
            LOGGER.warn("Could not save command bar. writer is null");
        }
    }

    public static void setDescriptionFile(String path) throws FileNotFoundException {
        AbstractFile file = FileFactory.getFile(path);
        if (file == null) {
            CommandBarIO.setDescriptionFile(new File(path));
        } else {
            CommandBarIO.setDescriptionFile(file);
        }
    }

    public static void setDescriptionFile(File file) throws FileNotFoundException {
        CommandBarIO.setDescriptionFile(FileFactory.getFile(file.getAbsolutePath()));
    }

    public static void setDescriptionFile(AbstractFile file) throws FileNotFoundException {
        if (file.isBrowsable()) {
            throw new FileNotFoundException("Not a valid file: " + file.getAbsolutePath());
        }
        commandBarFile = file;
    }

    public static AbstractFile getDescriptionFile() throws IOException {
        if (commandBarFile == null) {
            return PlatformManager.getPreferencesFolder().getChild("command_bar.xml");
        }
        return commandBarFile;
    }
}

