/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.commandbar;

import com.mucommander.RuntimeConstants;
import com.mucommander.io.backup.BackupOutputStream;
import com.mucommander.ui.main.commandbar.CommandBarAttributes;
import com.mucommander.ui.main.commandbar.CommandBarIO;
import com.mucommander.ui.text.KeyStrokeUtils;
import com.mucommander.xml.XmlAttributes;
import com.mucommander.xml.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommandBarWriter
extends CommandBarIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandBarWriter.class);
    private static CommandBarWriter instance;

    public static CommandBarWriter create() {
        if (instance == null) {
            instance = new CommandBarWriter();
        }
        return instance;
    }

    private CommandBarWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write() throws IOException {
        String[] commandBarActionIds = CommandBarAttributes.getActions();
        String[] commandBarAlterativeActionIds = CommandBarAttributes.getAlternateActions();
        KeyStroke commandBarModifier = CommandBarAttributes.getModifier();
        BackupOutputStream bos = new BackupOutputStream(CommandBarWriter.getDescriptionFile());
        try {
            new Writer(bos).write(commandBarActionIds, commandBarAlterativeActionIds, commandBarModifier);
            wasCommandBarModified = false;
        }
        catch (Exception e) {
            LOGGER.debug("Caught exception", e);
        }
        finally {
            bos.close();
        }
    }

    private static class Writer {
        private XmlWriter writer = null;

        private Writer(OutputStream stream) throws IOException {
            this.writer = new XmlWriter(stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(String[] actionIds, String[] alternativeActionIds, KeyStroke modifier) throws IOException {
            try {
                this.writer.writeCommentLine("See http://trac.mucommander.com/wiki/CommandBar for information on how to customize this file");
                XmlAttributes rootElementAttributes = new XmlAttributes();
                rootElementAttributes.add("modifier", KeyStrokeUtils.getKeyStrokeRepresentation(modifier));
                rootElementAttributes.add("version", RuntimeConstants.VERSION);
                this.writer.startElement("command_bar", rootElementAttributes, true);
                int nbCommandBarActions = actionIds.length;
                for (int i = 0; i < nbCommandBarActions; ++i) {
                    this.write(actionIds[i], alternativeActionIds[i]);
                }
            }
            finally {
                this.writer.endElement("command_bar");
            }
        }

        private void write(String actionId, String alternativeActionId) throws IOException {
            XmlAttributes attributes = new XmlAttributes();
            attributes.add("action_id", actionId);
            if (alternativeActionId != null) {
                attributes.add("alt_action_id", alternativeActionId);
            }
            LOGGER.trace("Writing button: action_id = " + attributes.getValue("action_id") + ", alt_action_id = " + attributes.getValue("alt_action_id"));
            this.writer.writeStandAloneElement("button", attributes);
        }
    }
}

