/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.menu;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.menu.OpenWithMenu;
import com.mucommander.ui.popup.MuActionsPopupMenu;
import javax.swing.JSeparator;

public class TablePopupMenu
extends MuActionsPopupMenu {
    public TablePopupMenu(MainFrame mainFrame, AbstractFile currentFolder, AbstractFile clickedFile, boolean parentFolderClicked, FileSet markedFiles) {
        super(mainFrame);
        if (clickedFile != null || parentFolderClicked) {
            this.addAction("Open");
            this.addAction("OpenNatively");
            this.add(new OpenWithMenu(mainFrame));
            this.addAction("OpenInNewTab");
        }
        if (DesktopManager.canOpenInFileManager(currentFolder)) {
            this.addAction("RevealInDesktop");
        }
        this.add(new JSeparator());
        if (clickedFile != null || markedFiles.size() > 0) {
            this.addAction("CopyFilesToClipboard");
            this.addAction("CopyFileNames");
            this.addAction("CopyFilePaths");
            this.add(new JSeparator());
        }
        this.addAction("MarkAll");
        this.addAction("UnmarkAll");
        this.addAction("MarkSelectedFile");
        this.add(new JSeparator());
        if (clickedFile != null) {
            this.addAction("Rename");
        }
        this.addAction("Delete");
        this.add(new JSeparator());
        this.addAction("ShowFileProperties");
        this.addAction("ChangePermissions");
        this.addAction("ChangeDate");
    }
}

