/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.quicklist;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.job.TempExecJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.WindowManager;
import com.mucommander.ui.quicklist.QuickListWithIcons;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentExecutedFilesQL
extends QuickListWithIcons<AbstractFile> {
    public static LinkedList<AbstractFile> list = new LinkedList();

    public RecentExecutedFilesQL() {
        super(ActionProperties.getActionLabel("ShowRecentExecutedFilesQL"), Translator.get("recent_executed_files_quick_list.empty_message", new String[0]));
    }

    @Override
    protected void acceptListItem(AbstractFile abstractFile) {
        MainFrame mainFrame = WindowManager.getCurrentMainFrame();
        if (abstractFile.getURL().getScheme().equals("file") && abstractFile.hasAncestor(LocalFile.class)) {
            try {
                DesktopManager.open(abstractFile);
            }
            catch (IOException iOException) {}
        } else {
            ProgressDialog progressDialog = new ProgressDialog(mainFrame, Translator.get("copy_dialog.copying", new String[0]));
            TempExecJob tempExecJob = new TempExecJob(progressDialog, mainFrame, abstractFile);
            progressDialog.start(tempExecJob);
        }
    }

    public static void addFile(AbstractFile file) {
        if (!list.remove(file) && list.size() > 10) {
            list.removeLast();
        }
        list.addFirst(file);
    }

    protected AbstractFile[] getData() {
        return list.toArray(new AbstractFile[0]);
    }

    @Override
    protected Icon itemToIcon(AbstractFile item) {
        return this.getIconOfFile(item);
    }
}

