/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.table;

import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CellLabel
extends JLabel {
    private static final Border CELL_BORDER = new EmptyBorder(1, 4, 1, 4);
    protected String lastText;
    protected ImageIcon lastIcon;
    protected String lastTooltip;
    protected Color lastForegroundColor;
    protected Color lastBackgroundColor;
    protected Color outlineColor;
    protected Color gradientColor;

    public CellLabel() {
        this.setBorder(CELL_BORDER);
    }

    public void setForeground(Color c) {
        if (c != null && !c.equals(this.lastForegroundColor) || this.lastForegroundColor != null && !this.lastForegroundColor.equals(c)) {
            super.setForeground(c);
            this.lastForegroundColor = c;
        }
    }

    public void setBackground(Color c) {
        if (c != null && !c.equals(this.lastBackgroundColor) || this.lastBackgroundColor != null && !this.lastBackgroundColor.equals(c)) {
            super.setBackground(c);
            this.lastBackgroundColor = c;
            this.gradientColor = null;
        }
    }

    public void setBackground(Color c1, Color c2) {
        if (c1.equals(c2)) {
            this.setBackground(c1);
        } else {
            this.lastBackgroundColor = c1;
            this.gradientColor = c2;
        }
    }

    public void setOutline(Color c) {
        this.outlineColor = c;
    }

    public void setText(String text) {
        if (text != null && !text.equals(this.lastText) || this.lastText != null && !this.lastText.equals(text)) {
            super.setText(text);
            this.lastText = text;
        }
    }

    public void setIcon(ImageIcon icon) {
        if (icon != this.lastIcon) {
            super.setIcon(icon);
            this.lastIcon = icon;
        }
    }

    public void setToolTipText(String tooltip) {
        if (tooltip != null && !tooltip.equals(this.lastTooltip) || this.lastTooltip != null && !this.lastTooltip.equals(tooltip)) {
            super.setToolTipText(tooltip);
            this.lastTooltip = tooltip;
        }
    }

    public void paint(Graphics g) {
        boolean doOutline;
        boolean bl = doOutline = this.outlineColor != null && !this.outlineColor.equals(this.lastBackgroundColor);
        if (this.gradientColor != null) {
            Graphics2D g2 = (Graphics2D)g;
            Paint oldPaint = g2.getPaint();
            g2.setPaint(new GradientPaint(0.0f, 0.0f, this.lastBackgroundColor, 0.0f, this.getHeight(), this.gradientColor, false));
            if (doOutline) {
                g2.fillRect(0, 1, this.getWidth(), this.getHeight() - 2);
            } else {
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g2.setPaint(oldPaint);
        }
        super.paint(g);
        if (doOutline) {
            this.paintOutline(g);
        }
    }

    protected void paintOutline(Graphics g) {
        g.setColor(this.outlineColor);
        g.drawLine(0, 0, this.getWidth(), 0);
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public boolean isOpaque() {
        if (this.gradientColor == null) {
            Color back = this.lastBackgroundColor;
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            return back == null || p == null || !back.equals(p.getBackground()) || !p.isOpaque();
        }
        return false;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals("text")) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

