/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.table;

import com.mucommander.ui.main.table.Column;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.main.table.FileTableConfiguration;
import com.mucommander.ui.main.table.FileTableHeaderRenderer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTableColumnModel
implements PropertyChangeListener,
TableColumnModel {
    private static final ListSelectionModel SELECTION_MODEL = new DefaultListSelectionModel();
    private WeakHashMap<TableColumnModelListener, ?> listeners = new WeakHashMap();
    private int widthCache = -1;
    private List<TableColumn> columns = new Vector<TableColumn>(Column.values().length);
    private boolean[] enabled = new boolean[Column.values().length];
    private boolean[] visibility = new boolean[Column.values().length];
    private int countCache = 1;
    private boolean columnSizesSet;

    public FileTableColumnModel(FileTableConfiguration conf) {
        for (Column c : Column.values()) {
            int columnIndex = c.ordinal();
            TableColumn column = new TableColumn(columnIndex);
            this.columns.add(column);
            column.setCellEditor(null);
            column.setHeaderValue(c.getLabel());
            if (!FileTable.usesTableHeaderRenderingProperties()) {
                column.setHeaderRenderer(new FileTableHeaderRenderer());
            }
            column.addPropertyChangeListener(this);
            if (conf.getWidth(c) != 0) {
                column.setWidth(conf.getWidth(c));
            }
            if (c == Column.NAME) {
                this.enabled[columnIndex] = true;
            } else {
                this.enabled[columnIndex] = conf.isEnabled(c);
                if (this.enabled[columnIndex]) {
                    ++this.countCache;
                }
            }
            column.setMinWidth(c.getMinimumColumnWidth());
            this.visibility[columnIndex] = this.enabled[columnIndex];
        }
        Collections.sort(this.columns, new ColumnSorter(conf));
    }

    public synchronized FileTableConfiguration getConfiguration() {
        FileTableConfiguration conf = new FileTableConfiguration();
        for (Column c : Column.values()) {
            TableColumn column = this.columns.get(c.ordinal());
            Column modelC = Column.valueOf(column.getModelIndex());
            int modelCIndex = modelC.ordinal();
            conf.setEnabled(modelC, this.enabled[modelCIndex]);
            conf.setPosition(modelC, c.ordinal());
            conf.setWidth(modelC, column.getWidth());
        }
        return conf;
    }

    public synchronized boolean isColumnEnabled(Column column) {
        return this.enabled[column.ordinal()];
    }

    public synchronized void setColumnEnabled(Column column, boolean enabled) {
        this.enabled[column.ordinal()] = enabled;
    }

    synchronized void setColumnVisible(Column column, boolean visible) {
        int columnVal = column.ordinal();
        if (this.visibility[columnVal] != visible) {
            this.visibility[columnVal] = visible;
            this.widthCache = -1;
            if (visible) {
                ++this.countCache;
                this.triggerColumnAdded(new TableColumnModelEvent(this, columnVal, columnVal));
            } else {
                --this.countCache;
                this.triggerColumnRemoved(new TableColumnModelEvent(this, columnVal, columnVal));
            }
        }
    }

    public synchronized boolean isColumnVisible(Column column) {
        return this.visibility[column.ordinal()];
    }

    @Override
    public void addColumn(TableColumn column) {
        this.setColumnVisible(Column.valueOf(column.getModelIndex()), true);
    }

    @Override
    public void removeColumn(TableColumn column) {
        this.setColumnVisible(Column.valueOf(column.getModelIndex()), false);
    }

    private synchronized int getInternalIndex(int index) {
        int visibleIndex = -1;
        for (int i = 0; i < this.visibility.length; ++i) {
            TableColumn column = this.columns.get(i);
            if (!this.visibility[column.getModelIndex()] || ++visibleIndex != index) continue;
            return i;
        }
        throw new ArrayIndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public synchronized TableColumn getColumn(int index) {
        return this.columns.get(this.getInternalIndex(index));
    }

    public synchronized TableColumn getColumnFromId(int id) {
        return this.columns.get(id);
    }

    public synchronized int getColumnPosition(int id) {
        for (int i = 0; i < this.visibility.length; ++i) {
            if (this.columns.get(i).getModelIndex() != id) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized int getColumnCount() {
        return this.countCache;
    }

    @Override
    public synchronized void moveColumn(int from, int to) {
        if (from == to) {
            this.triggerColumnMoved(new TableColumnModelEvent(this, from, to));
            return;
        }
        int index = this.getInternalIndex(from);
        TableColumn column = this.columns.get(index);
        this.columns.remove(index);
        if (to == this.countCache - 1) {
            this.columns.add(column);
        } else {
            index = this.getInternalIndex(to);
            this.columns.add(index, column);
        }
        this.triggerColumnMoved(new TableColumnModelEvent(this, from, to));
    }

    @Override
    public int getColumnIndex(Object identifier) {
        return 0;
    }

    @Override
    public int getColumnIndexAtX(int x) {
        int count = this.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if ((x -= this.getColumn(i).getWidth()) >= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTotalColumnWidth() {
        if (this.widthCache == -1) {
            this.computeWidthCache();
        }
        return this.widthCache;
    }

    private void computeWidthCache() {
        Enumeration<TableColumn> elements = this.getColumns();
        this.widthCache = 0;
        while (elements.hasMoreElements()) {
            this.widthCache += elements.nextElement().getWidth();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if (name.equals("width")) {
            this.columnSizesSet = true;
            this.widthCache = -1;
            this.triggerColumnMarginChanged(new ChangeEvent(this));
        }
    }

    boolean wereColumnSizesSet() {
        return this.columnSizesSet;
    }

    @Override
    public int getColumnMargin() {
        return 0;
    }

    @Override
    public void setColumnMargin(int margin) {
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener listener) {
        this.listeners.put(listener, null);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener listener) {
        this.listeners.remove(listener);
    }

    private void triggerColumnAdded(TableColumnModelEvent event) {
        for (TableColumnModelListener listener : this.listeners.keySet()) {
            listener.columnAdded(event);
        }
    }

    private void triggerColumnMarginChanged(ChangeEvent event) {
        for (TableColumnModelListener listener : this.listeners.keySet()) {
            listener.columnMarginChanged(event);
        }
    }

    private void triggerColumnMoved(TableColumnModelEvent event) {
        for (TableColumnModelListener listener : this.listeners.keySet()) {
            listener.columnMoved(event);
        }
    }

    private void triggerColumnRemoved(TableColumnModelEvent event) {
        for (TableColumnModelListener listener : this.listeners.keySet()) {
            listener.columnRemoved(event);
        }
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return false;
    }

    @Override
    public int getSelectedColumnCount() {
        return 0;
    }

    @Override
    public int[] getSelectedColumns() {
        return new int[0];
    }

    @Override
    public void setColumnSelectionAllowed(boolean flag) {
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return SELECTION_MODEL;
    }

    @Override
    public void setSelectionModel(ListSelectionModel model) {
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return new ColumnEnumeration();
    }

    public Iterator<TableColumn> getAllColumns() {
        return this.columns.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnSorter
    implements Comparator<TableColumn> {
        private FileTableConfiguration conf;

        public ColumnSorter(FileTableConfiguration conf) {
            this.conf = conf;
        }

        @Override
        public int compare(TableColumn tc1, TableColumn tc2) {
            int id2;
            int index2;
            int id1 = tc1.getModelIndex();
            int index1 = this.conf.getPosition(Column.valueOf(id1));
            if (index1 < (index2 = this.conf.getPosition(Column.valueOf(id2 = tc2.getModelIndex())))) {
                return -1;
            }
            if (index1 == index2) {
                if (id1 < id2) {
                    return -1;
                }
                if (id1 == id2) {
                    return 0;
                }
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnEnumeration
    implements Enumeration<TableColumn> {
        private int nextIndex = -1;

        public ColumnEnumeration() {
            this.findNextElement();
        }

        private void findNextElement() {
            ++this.nextIndex;
            while (this.nextIndex < FileTableColumnModel.this.visibility.length) {
                TableColumn column = (TableColumn)FileTableColumnModel.this.columns.get(this.nextIndex);
                if (FileTableColumnModel.this.visibility[column.getModelIndex()]) break;
                ++this.nextIndex;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextIndex < FileTableColumnModel.this.visibility.length;
        }

        @Override
        public TableColumn nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            TableColumn column = (TableColumn)FileTableColumnModel.this.columns.get(this.nextIndex);
            this.findNextElement();
            return column;
        }
    }
}

