/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.table;

import com.mucommander.desktop.DesktopManager;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.Column;
import com.mucommander.ui.main.table.FileTable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.table.JTableHeader;

public class FileTableHeader
extends JTableHeader
implements MouseListener {
    private FileTable table;

    public FileTableHeader(FileTable table) {
        super(table.getColumnModel());
        this.table = table;
        this.addMouseListener(this);
    }

    public boolean getReorderingAllowed() {
        return true;
    }

    public void mouseClicked(MouseEvent e) {
        Column col = Column.valueOf(this.table.convertColumnIndexToModel(this.getColumnModel().getColumnIndexAtX(e.getX())));
        this.table.requestFocus();
        if (DesktopManager.isLeftMouseButton(e)) {
            if (this.table.getSortInfo().getCriterion() == col) {
                this.table.reverseSortOrder();
            } else {
                this.table.sortBy(col);
            }
        } else if (DesktopManager.isRightMouseButton(e)) {
            JCheckBoxMenuItem checkboxMenuItem;
            JPopupMenu popupMenu = new JPopupMenu();
            MainFrame mainFrame = this.table.getFolderPanel().getMainFrame();
            for (Column c : Column.values()) {
                if (c == Column.NAME) continue;
                checkboxMenuItem = new JCheckBoxMenuItem(ActionManager.getActionInstance(c.getToggleColumnActionId(), mainFrame));
                checkboxMenuItem.setSelected(this.table.isColumnEnabled(c));
                checkboxMenuItem.setEnabled(this.table.isColumnDisplayable(c));
                checkboxMenuItem.setText(c.getLabel());
                popupMenu.add(checkboxMenuItem);
            }
            popupMenu.add(new JSeparator());
            checkboxMenuItem = new JCheckBoxMenuItem(ActionManager.getActionInstance("ToggleAutoSize", mainFrame));
            checkboxMenuItem.setSelected(mainFrame.isAutoSizeColumnsEnabled());
            popupMenu.add(checkboxMenuItem);
            popupMenu.show(this, e.getX(), e.getY());
            popupMenu.setVisible(true);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

