/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.table;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.ui.border.MutableLineBorder;
import com.mucommander.ui.dnd.FileDropTargetListener;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.menu.TablePopupMenu;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeListener;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.Color;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class FileTableWrapperForDisplay
extends JScrollPane
implements ThemeListener,
FocusListener {
    private FileTable fileTable;
    private Color borderColor;
    private Color unfocusedBorderColor;
    private Color backgroundColor;
    private Color unfocusedBackgroundColor;
    private Color unmatchedBackgroundColor;
    private MainFrame mainFrame;

    public FileTableWrapperForDisplay(final FileTable fileTable, final MainFrame mainFrame) {
        super(fileTable, 20, 31);
        this.mainFrame = mainFrame;
        this.fileTable = fileTable;
        this.backgroundColor = ThemeManager.getCurrentColor(1);
        this.unmatchedBackgroundColor = ThemeManager.getCurrentColor(5);
        this.unfocusedBorderColor = ThemeManager.getCurrentColor(56);
        this.unfocusedBackgroundColor = ThemeManager.getCurrentColor(3);
        this.setBorder(new MutableLineBorder(this.unfocusedBorderColor, 1));
        this.borderColor = ThemeManager.getCurrentColor(0);
        this.getViewport().setBackground(this.unfocusedBackgroundColor);
        fileTable.setBackground(this.unfocusedBackgroundColor);
        InputMap inputMap = this.getInputMap(1);
        inputMap.clear();
        inputMap.setParent(null);
        fileTable.addFocusListener(this);
        FileDropTargetListener dropTargetListener = new FileDropTargetListener(fileTable.getFolderPanel(), false);
        fileTable.setDropTarget(new DropTarget(fileTable, dropTargetListener));
        this.setDropTarget(new DropTarget(this, dropTargetListener));
        ThemeManager.addCurrentThemeListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (DesktopManager.isLeftMouseButton(e)) {
                    fileTable.requestFocus();
                } else if (DesktopManager.isRightMouseButton(e)) {
                    if (!fileTable.hasFocus()) {
                        fileTable.requestFocus();
                    }
                    AbstractFile currentFolder = fileTable.getCurrentFolder();
                    new TablePopupMenu(mainFrame, currentFolder, null, false, fileTable.getFileTableModel().getMarkedFiles()).show(FileTableWrapperForDisplay.this, e.getX(), e.getY());
                }
            }
        });
    }

    public void setVisible(boolean visible) {
        if (visible) {
            super.setVisible(true);
        }
    }

    public boolean requestFocusInWindow() {
        return this.fileTable.requestFocusInWindow();
    }

    public void dimBackground() {
        this.fileTable.setBackground(this.unmatchedBackgroundColor);
        this.getViewport().setBackground(this.unmatchedBackgroundColor);
    }

    public void undimBackground() {
        Color newColor = this.fileTable.hasFocus() ? this.backgroundColor : this.unfocusedBackgroundColor;
        if (newColor.equals(this.getViewport().getBackground())) {
            this.fileTable.repaint();
        } else {
            this.fileTable.setBackground(newColor);
            this.getViewport().setBackground(newColor);
        }
    }

    public void focusGained(FocusEvent e) {
        this.setBorderColor(this.borderColor);
        this.getViewport().setBackground(this.backgroundColor);
        this.fileTable.setBackground(this.backgroundColor);
        this.getViewport().repaint();
    }

    public void focusLost(FocusEvent e) {
        this.setBorderColor(this.unfocusedBorderColor);
        this.getViewport().setBackground(this.unfocusedBackgroundColor);
        this.fileTable.setBackground(this.unfocusedBackgroundColor);
    }

    private void setBorderColor(Color color) {
        Border border = this.getBorder();
        if (border instanceof MutableLineBorder) {
            ((MutableLineBorder)border).setLineColor(color);
        }
    }

    public void colorChanged(ColorChangedEvent event) {
        switch (event.getColorId()) {
            case 0: {
                this.borderColor = event.getColor();
                if (!this.fileTable.hasFocus()) break;
                this.setBorderColor(this.borderColor);
                this.repaint();
                break;
            }
            case 56: {
                this.unfocusedBorderColor = event.getColor();
                if (this.fileTable.hasFocus()) break;
                this.setBorderColor(this.unfocusedBorderColor);
                this.repaint();
                break;
            }
            case 1: {
                this.backgroundColor = event.getColor();
                if (!this.fileTable.hasFocus()) break;
                this.getViewport().setBackground(this.backgroundColor);
                this.fileTable.setBackground(this.backgroundColor);
                break;
            }
            case 3: {
                this.unfocusedBackgroundColor = event.getColor();
                if (this.fileTable.hasFocus()) break;
                this.getViewport().setBackground(this.unfocusedBackgroundColor);
                this.fileTable.setBackground(this.unfocusedBackgroundColor);
                break;
            }
            case 5: {
                this.unmatchedBackgroundColor = event.getColor();
            }
        }
    }

    public void fontChanged(FontChangedEvent event) {
    }
}

