/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.tabs;

import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.tabs.FileTableTab;
import com.mucommander.ui.main.tabs.FileTableTabHeader;
import com.mucommander.ui.main.tabs.FileTableTabPopupMenu;
import com.mucommander.ui.tabs.TabbedPane;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTableTabbedPane
extends TabbedPane<FileTableTab> {
    private JComponent fileTableComponent;
    private MainFrame mainFrame;
    private FolderPanel folderPanel;

    public FileTableTabbedPane(MainFrame mainFrame, FolderPanel folderPanel, JComponent fileTableComponent) {
        this.fileTableComponent = fileTableComponent;
        this.mainFrame = mainFrame;
        this.folderPanel = folderPanel;
        this.setTabLayoutPolicy(1);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Point clickedPoint = e.getPoint();
                int selectedTabIndex = FileTableTabbedPane.this.indexAtLocation(clickedPoint.x, clickedPoint.y);
                if (selectedTabIndex != -1 && DesktopManager.isRightMouseButton(e)) {
                    FileTableTabbedPane.this.setSelectedIndex(selectedTabIndex);
                    new FileTableTabPopupMenu(FileTableTabbedPane.this.mainFrame).show(FileTableTabbedPane.this, clickedPoint.x, clickedPoint.y);
                }
            }
        });
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.fileTableComponent.requestFocusInWindow();
    }

    @Override
    public void removeTabAt(int index) {
        super.removeTabAt(index);
        if (index == 0 && this.getTabCount() > 0) {
            this.setComponentAt(0, this.fileTableComponent);
        }
    }

    public void setTabHeader(int index, FileTableTabHeader component) {
        super.setTabComponentAt(index, component);
    }

    private FileTableTabHeader getTabHeader(int index) {
        return (FileTableTabHeader)this.getTabComponentAt(index);
    }

    @Override
    public void add(FileTableTab tab, int index) {
        this.add((Component)(this.getTabCount() == 0 ? this.fileTableComponent : new JLabel()), index);
        this.setTitleAt(index, tab.getLocation().getName());
        this.setToolTipTextAt(index, tab.getLocation().getAbsolutePath());
    }

    @Override
    public void setTitleAt(int index, String title) {
        if (JavaVersions.JAVA_1_5.isCurrentOrLower()) {
            super.setTitleAt(index, title);
        } else {
            FileTableTabHeader header = this.getTabHeader(index);
            if (header == null) {
                header = new FileTableTabHeader(this.folderPanel);
                this.setTabHeader(index, header);
            }
            header.setTitle(title);
        }
    }

    @Override
    public String getTitleAt(int index) {
        if (JavaVersions.JAVA_1_5.isCurrentOrLower()) {
            return super.getTitleAt(index);
        }
        FileTableTabHeader header = this.getTabHeader(index);
        return header != null ? header.getTitle() : "";
    }

    @Override
    public void setSelectedIndex(int index) {
        if (!this.mainFrame.getNoEventsMode()) {
            super.setSelectedIndex(index);
            this.requestFocusInWindow();
        }
    }

    @Override
    public void update(FileTableTab tab, int index) {
        this.setTitleAt(index, tab.getLocation().getName());
        this.setToolTipTextAt(index, tab.getLocation().getAbsolutePath());
        this.doLayout();
    }

    @Override
    public void show(FileTableTab t) {
        this.mainFrame.setNoEventsMode(true);
        FolderPanel.ChangeFolderThread changeFolderThread = this.folderPanel.tryChangeCurrentFolder(t.getLocation());
        if (changeFolderThread == null) {
            this.mainFrame.setNoEventsMode(false);
        }
        this.validate();
    }
}

