/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.tabs;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.ui.event.LocationEvent;
import com.mucommander.ui.event.LocationListener;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.tabs.FileTableTab;
import com.mucommander.ui.main.tabs.FileTableTabHeader;
import com.mucommander.ui.main.tabs.FileTableTabsDisplayFactory;
import com.mucommander.ui.tabs.HideableTabbedPane;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTableTabs
extends HideableTabbedPane<FileTableTab>
implements LocationListener {
    private FolderPanel folderPanel;

    public FileTableTabs(MainFrame mainFrame, FolderPanel folderPanel, AbstractFile[] initialFolders) {
        super(new FileTableTabsDisplayFactory(mainFrame, folderPanel));
        this.folderPanel = folderPanel;
        folderPanel.getLocationManager().addLocationListener(this);
        for (AbstractFile folder : initialFolders) {
            this.addTab(FileTableTab.create(folder));
        }
        this.selectTab(0);
    }

    @Override
    protected void selectTab(int index) {
        super.selectTab(index);
        try {
            this.folderPanel.tryChangeCurrentFolder(((FileTableTab)this.getTab(index)).getLocation(), null, true).join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to read any drive");
        }
    }

    public List<FileTableTab> getClonedTabs() {
        ArrayList<FileTableTab> tabs = new ArrayList<FileTableTab>();
        Iterator tabsIterator = this.getTabsIterator();
        while (tabsIterator.hasNext()) {
            tabs.add(((FileTableTab)tabsIterator.next()).clone());
        }
        return tabs;
    }

    public void add(AbstractFile file) {
        this.addAndSelectTab(FileTableTab.create(file));
    }

    public void add(FileTableTab tab) {
        this.addAndSelectTab(tab);
    }

    public FileTableTab closeCurrentTab() {
        return (FileTableTab)this.removeTab();
    }

    public void closeDuplicateTabs() {
        this.removeDuplicateTabs();
    }

    public void closeOtherTabs() {
        this.removeOtherTabs();
    }

    public void close(FileTableTabHeader fileTableTabHeader) {
        this.removeTab(fileTableTabHeader);
    }

    @Override
    public void locationChanged(LocationEvent locationEvent) {
        this.updateTab(FileTableTab.create(this.folderPanel.getCurrentFolder()));
    }

    @Override
    public void locationCancelled(LocationEvent locationEvent) {
        this.updateTab(FileTableTab.create(this.folderPanel.getCurrentFolder()));
    }

    @Override
    public void locationFailed(LocationEvent locationEvent) {
        this.updateTab(FileTableTab.create(this.folderPanel.getCurrentFolder()));
    }

    @Override
    public void locationChanging(LocationEvent locationEvent) {
    }
}

