/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.toolbar;

import com.mucommander.commons.conf.ConfigurationEvent;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.action.impl.GoBackAction;
import com.mucommander.ui.action.impl.GoForwardAction;
import com.mucommander.ui.action.impl.OpenLocationAction;
import com.mucommander.ui.button.NonFocusableButton;
import com.mucommander.ui.button.PopupButton;
import com.mucommander.ui.button.RolloverButtonAdapter;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.toolbar.ToolBarAttributes;
import com.mucommander.ui.main.toolbar.ToolBarAttributesListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class ToolBar
extends JToolBar
implements ConfigurationListener,
ToolBarAttributesListener,
MouseListener {
    private MainFrame mainFrame;
    private RolloverButtonAdapter rolloverButtonAdapter;
    private static final Dimension SEPARATOR_DIMENSION = new Dimension(10, 16);
    private static final boolean USE_MAC_OS_X_CLIENT_PROPERTIES = OsFamilies.MAC_OS_X.isCurrent() && OsVersions.MAC_OS_X_10_5.isCurrentOrHigher();
    private static float scaleFactor = Math.max(1.0f, MuConfigurations.getPreferences().getVariable(MuPreference.TOOLBAR_ICON_SCALE, 1.0f));

    public ToolBar(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.setBorderPainted(false);
        this.setFloatable(false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.addMouseListener(this);
        MuConfigurations.addPreferencesListener(this);
        this.rolloverButtonAdapter = new RolloverButtonAdapter();
        this.addButtons(ToolBarAttributes.getActions());
        ToolBarAttributes.addToolBarAttributesListener(this);
    }

    private void addButtons(String[] actionIds) {
        for (String actionId : actionIds) {
            if (actionId == null) {
                this.addSeparator(SEPARATOR_DIMENSION);
                continue;
            }
            MuAction action = ActionManager.getActionInstance(actionId, this.mainFrame);
            if (action.getIcon() == null) continue;
            this.addButton(action);
        }
        if (USE_MAC_OS_X_CLIENT_PROPERTIES) {
            int nbComponents = this.getComponentCount();
            for (int i = 0; i < nbComponents; ++i) {
                boolean hasNext;
                Component comp = this.getComponent(i);
                if (!(comp instanceof JButton)) continue;
                boolean hasPrevious = i != 0 && this.getComponent(i - 1) instanceof JButton;
                boolean bl = hasNext = i != nbComponents - 1 && this.getComponent(i + 1) instanceof JButton;
                String segmentPosition = hasPrevious && hasNext ? "middle" : (hasPrevious ? "last" : (hasNext ? "first" : "only"));
                ((JButton)comp).putClientProperty("JButton.segmentPosition", segmentPosition);
            }
        }
    }

    private void addButton(MuAction action) {
        NonFocusableButton button = action instanceof GoBackAction || action instanceof GoForwardAction ? new HistoryPopupButton(action) : new NonFocusableButton(action);
        button.setText(null);
        String toolTipText = action.getLabel();
        String acceleratorText = action.getAcceleratorText();
        if (acceleratorText != null) {
            toolTipText = toolTipText + " (" + acceleratorText + ")";
        }
        button.setToolTipText(toolTipText);
        this.setButtonIcon(button);
        if (USE_MAC_OS_X_CLIENT_PROPERTIES) {
            button.putClientProperty("JButton.buttonType", "segmentedTextured");
            button.setRolloverEnabled(true);
        } else {
            RolloverButtonAdapter.setButtonDecoration(button);
            button.addMouseListener(this.rolloverButtonAdapter);
        }
        this.add(button);
    }

    private void setButtonIcon(JButton button) {
        ImageIcon icon = IconManager.getScaledIcon((ImageIcon)button.getAction().getValue("SmallIcon"), scaleFactor);
        if (!USE_MAC_OS_X_CLIENT_PROPERTIES) {
            icon = IconManager.getPaddedIcon(icon, new Insets(3, 4, 3, 4));
        }
        button.setIcon(icon);
    }

    public void configurationChanged(ConfigurationEvent event) {
        String var = event.getVariable();
        if (var.equals("toolbar.icon_scale")) {
            scaleFactor = event.getFloatValue();
            Component[] components = this.getComponents();
            int nbComponents = components.length;
            for (int i = 0; i < nbComponents; ++i) {
                if (!(components[i] instanceof JButton)) continue;
                this.setButtonIcon((JButton)components[i]);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (source == this && DesktopManager.isRightMouseButton(e)) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(ActionManager.getActionInstance("ToggleToolBar", this.mainFrame));
            popupMenu.show(this, e.getX(), e.getY());
            popupMenu.setVisible(true);
        }
    }

    public void mouseEntered(MouseEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            ((JButton)source).setBorderPainted(true);
        }
    }

    public void mouseExited(MouseEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            ((JButton)source).setBorderPainted(false);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void toolBarActionsChanged() {
        this.removeAll();
        this.addButtons(ToolBarAttributes.getActions());
    }

    private class HistoryPopupButton
    extends PopupButton {
        private MuAction action;

        private HistoryPopupButton(MuAction action) {
            super(action);
            this.action = action;
        }

        public JPopupMenu getPopupMenu() {
            FileURL[] history = this.action instanceof GoBackAction ? ToolBar.this.mainFrame.getActivePanel().getFolderHistory().getBackFolders() : ToolBar.this.mainFrame.getActivePanel().getFolderHistory().getForwardFolders();
            int historyLen = history.length;
            if (history.length == 0) {
                return null;
            }
            JPopupMenu popupMenu = new JPopupMenu();
            for (int i = 0; i < historyLen; ++i) {
                popupMenu.add(new OpenLocationAction(ToolBar.this.mainFrame, new Hashtable<String, Object>(), history[i]));
            }
            return popupMenu;
        }
    }
}

