/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.toolbar;

import com.mucommander.ui.main.toolbar.ToolBarAttributesListener;
import java.util.WeakHashMap;

public class ToolBarAttributes {
    private static String[] actionIds;
    private static boolean useDefaultActions;
    private static final WeakHashMap<ToolBarAttributesListener, ?> listeners;
    private static final String[] DEFAULT_TOOLBAR_ACTIONS;

    private static String[] trimActionsArray(String[] actions) {
        int start;
        int end = actions.length;
        for (start = 0; start < end && actions[start] == null; ++start) {
        }
        if (start == end) {
            return new String[0];
        }
        while (end > start && actions[end - 1] == null) {
            --end;
        }
        int newLen = end - start;
        String[] newActions = new String[newLen];
        System.arraycopy(actions, start, newActions, 0, newLen);
        return newActions;
    }

    public static void setActions(String[] actions) {
        actionIds = ToolBarAttributes.trimActionsArray(actions);
        useDefaultActions = false;
        ToolBarAttributes.fireActionsChanged();
    }

    public static boolean areDefaultAttributes() {
        if (useDefaultActions) {
            return true;
        }
        int nbActions = actionIds.length;
        if (nbActions != DEFAULT_TOOLBAR_ACTIONS.length) {
            return false;
        }
        for (int i = 0; i < nbActions; ++i) {
            if (ToolBarAttributes.equals(actionIds[i], DEFAULT_TOOLBAR_ACTIONS[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(Object action1, Object action2) {
        if (action1 == null) {
            return action2 == null;
        }
        return action1.equals(action2);
    }

    public static String[] getActions() {
        return useDefaultActions ? DEFAULT_TOOLBAR_ACTIONS : actionIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToolBarAttributesListener(ToolBarAttributesListener listener) {
        WeakHashMap<ToolBarAttributesListener, ?> weakHashMap = listeners;
        synchronized (weakHashMap) {
            listeners.put(listener, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireActionsChanged() {
        WeakHashMap<ToolBarAttributesListener, ?> weakHashMap = listeners;
        synchronized (weakHashMap) {
            for (ToolBarAttributesListener listener : listeners.keySet()) {
                listener.toolBarActionsChanged();
            }
        }
    }

    static {
        useDefaultActions = true;
        listeners = new WeakHashMap();
        DEFAULT_TOOLBAR_ACTIONS = new String[]{"NewWindow", null, "GoBack", "GoForward", null, "GoToParent", "GoToHome", null, "Stop", null, "MarkGroup", "UnmarkGroup", null, "SwapFolders", "SetSameFolder", null, "Pack", "Unpack", null, "AddBookmark", "EditBookmarks", "EditCredentials", null, "ConnectToServer", "ShowServerConnections", "RunCommand", "Email", null, "RevealInDesktop", "ShowFileProperties", null, "ShowPreferences"};
    }
}

