/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.toolbar;

import com.mucommander.RuntimeConstants;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.io.backup.BackupInputStream;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.main.toolbar.ToolBarIO;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ToolBarReader
extends ToolBarIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolBarReader.class);
    private List<String> actionIdsV;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ToolBarReader(AbstractFile descriptionFile) throws Exception {
        InputStream in = null;
        try {
            in = new BackupInputStream(descriptionFile);
            SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)this);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String[] getActionsRead() {
        int nbActions = this.actionIdsV.size();
        String[] actionIds = new String[nbActions];
        this.actionIdsV.toArray(actionIds);
        return actionIds;
    }

    public void startDocument() {
        this.actionIdsV = new Vector<String>();
    }

    public void endDocument() {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String fileVersion;
        if (qName.equals("button")) {
            String actionIdAttribute = attributes.getValue("action_id");
            if (actionIdAttribute != null) {
                if (ActionManager.isActionExist(actionIdAttribute)) {
                    this.actionIdsV.add(actionIdAttribute);
                } else {
                    LOGGER.warn("Error in toolbar.xml: action id \"" + actionIdAttribute + "\" not found");
                }
            } else {
                String actionClassAttribute = attributes.getValue("action");
                String actionId = ActionManager.extrapolateId(actionClassAttribute);
                if (ActionManager.isActionExist(actionId)) {
                    this.actionIdsV.add(actionId);
                } else {
                    LOGGER.warn("Error in toolbar.xml: action id for class " + actionClassAttribute + " was not found");
                }
            }
        } else if (qName.equals("separator")) {
            this.actionIdsV.add(null);
        } else if (qName.equals("toolbar") && !RuntimeConstants.VERSION.equals(fileVersion = attributes.getValue("version"))) {
            ToolBarReader.setModified();
        }
    }
}

