/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.toolbar;

import com.mucommander.RuntimeConstants;
import com.mucommander.io.backup.BackupOutputStream;
import com.mucommander.ui.main.toolbar.ToolBarAttributes;
import com.mucommander.ui.main.toolbar.ToolBarIO;
import com.mucommander.xml.XmlAttributes;
import com.mucommander.xml.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolBarWriter
extends ToolBarIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolBarWriter.class);
    private static ToolBarWriter instance;

    public static ToolBarWriter create() {
        if (instance == null) {
            instance = new ToolBarWriter();
        }
        return instance;
    }

    private ToolBarWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write() throws IOException {
        String[] actionIds = ToolBarAttributes.getActions();
        BackupOutputStream bos = new BackupOutputStream(ToolBarWriter.getDescriptionFile());
        try {
            new Writer(bos).write(actionIds);
            wasToolBarModified = false;
        }
        catch (Exception e) {
            LOGGER.debug("Caught exception", e);
        }
        finally {
            bos.close();
        }
    }

    private static class Writer {
        private XmlWriter writer = null;

        private Writer(OutputStream stream) throws IOException {
            this.writer = new XmlWriter(stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(String[] actionIds) throws IOException {
            try {
                this.writer.writeCommentLine("See http://trac.mucommander.com/wiki/ToolBar for information on how to customize this file");
                XmlAttributes rootElementAttributes = new XmlAttributes();
                rootElementAttributes.add("version", RuntimeConstants.VERSION);
                this.writer.startElement("toolbar", rootElementAttributes, true);
                int nbToolBarActions = actionIds.length;
                for (int i = 0; i < nbToolBarActions; ++i) {
                    this.write(actionIds[i]);
                }
            }
            finally {
                this.writer.endElement("toolbar");
            }
        }

        private void write(String actionId) throws IOException {
            if (actionId == null) {
                this.writer.writeStandAloneElement("separator");
            } else {
                XmlAttributes attributes = new XmlAttributes();
                attributes.add("action_id", actionId);
                this.writer.writeStandAloneElement("button", attributes);
            }
        }
    }
}

