/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.tree;

import com.mucommander.ui.main.tree.IOThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractIOThreadManager
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIOThreadManager.class);
    protected final List<Runnable> queue = Collections.synchronizedList(new ArrayList());
    protected IOThread ioThread;
    protected long blockThreshold;

    public AbstractIOThreadManager(String name, long blockThreshold) {
        super(name);
        this.blockThreshold = blockThreshold;
        this.ioThread = new IOThread(this.queue, blockThreshold);
        this.ioThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable task) {
        this.queue.add(task);
        IOThread iOThread = this.ioThread;
        synchronized (iOThread) {
            this.ioThread.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!AbstractIOThreadManager.interrupted()) {
            List<Runnable> list = this.queue;
            synchronized (list) {
                if (this.ioThread.isBlocked()) {
                    LOGGER.debug("Killing IOThread " + this.ioThread);
                    this.ioThread.interrupt();
                    this.ioThread = new IOThread(this.queue, this.blockThreshold);
                    this.ioThread.start();
                }
            }
            try {
                AbstractIOThreadManager.sleep(this.blockThreshold);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        this.ioThread.interrupt();
    }
}

