/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.tree;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.ui.main.tree.FilesTreeModel;
import com.mucommander.ui.theme.ThemeCache;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class FoldersTreeRenderer
extends DefaultTreeCellRenderer {
    private JTree tree;
    private FilesTreeModel model;

    public FoldersTreeRenderer(JTree tree) {
        this.tree = tree;
        this.model = (FilesTreeModel)tree.getModel();
    }

    public Color getBackgroundSelectionColor() {
        if (this.tree != null && this.tree.hasFocus()) {
            return ThemeCache.backgroundColors[1][1];
        }
        return ThemeCache.backgroundColors[0][1];
    }

    public Color getBackgroundNonSelectionColor() {
        if (this.tree != null && this.tree.hasFocus()) {
            return ThemeCache.backgroundColors[1][0];
        }
        return ThemeCache.backgroundColors[0][0];
    }

    public Color getForeground() {
        if (this.tree != null && this.tree.hasFocus()) {
            return this.selected ? ThemeCache.foregroundColors[1][1][1] : ThemeCache.foregroundColors[1][0][1];
        }
        return this.selected ? ThemeCache.foregroundColors[0][1][1] : ThemeCache.foregroundColors[0][0][1];
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        AbstractFile file = (AbstractFile)value;
        String name = file.isRoot() ? file.getAbsolutePath() : file.getName();
        super.getTreeCellRendererComponent(tree, name, sel, expanded, leaf, row, hasFocus);
        this.setIcon(this.model.getCurrentIcon(file));
        return this;
    }
}

