/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.progress;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JTextField;

public class ProgressTextField
extends JTextField {
    private int progressValue;
    private Color progressColor;

    public ProgressTextField(int initialProgressValue, Color progressColor) {
        this.progressValue = initialProgressValue;
        this.progressColor = progressColor;
    }

    public void setProgressValue(int value) {
        this.progressValue = value;
        this.repaint();
    }

    public void setProgressColor(Color color) {
        if (color != null && this.progressColor != null && !color.equals(this.progressColor)) {
            this.progressColor = color;
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.progressValue > 0) {
            g.setColor(this.progressColor);
            g.fillRect(0, 0, (int)((float)(this.getWidth() * this.progressValue) / 100.0f), this.getHeight());
        }
    }
}

