/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.quicklist;

import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.quicklist.item.QuickListHeaderItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.LineBorder;

public abstract class QuickList
extends JPopupMenu
implements FocusListener {
    protected QuickListHeaderItem headerMenuItem;
    protected FolderPanel folderPanel;
    private List<Component> items = new Vector<Component>();

    protected QuickList(String header) {
        this.setBorder(new PopupsBorder());
        this.headerMenuItem = new QuickListHeaderItem(header);
        this.add(this.headerMenuItem);
        this.setFocusTraversalKeysEnabled(false);
    }

    protected abstract boolean prepareForShowing();

    public void show(FolderPanel folderPanel) {
        this.folderPanel = folderPanel;
        if (this.prepareForShowing()) {
            Dimension dim = this.getPreferredSize();
            int x = Math.max((folderPanel.getWidth() - (int)dim.getWidth()) / 2, 0);
            int y = folderPanel.getLocationTextField().getHeight() + Math.max((folderPanel.getHeight() - (int)dim.getHeight()) / 3, 0);
            this.show(folderPanel, x, y);
        }
    }

    public Component add(Component comp) {
        this.items.add(comp);
        return super.add(comp);
    }

    public JMenuItem add(JMenuItem comp) {
        this.items.add(comp);
        return super.add(comp);
    }

    public Dimension getPreferredSize() {
        double width = 2.0;
        double height = 2.0;
        for (Component item : this.items) {
            width = Math.max(width, item.getPreferredSize().getWidth());
            height += item.getPreferredSize().getHeight();
        }
        return new Dimension((int)Math.ceil(Math.max(this.folderPanel == null ? 0.0 : (double)(this.folderPanel.getWidth() / 2), width * 1.05)), (int)Math.ceil(height));
    }

    public FolderPanel getPanel() {
        return this.folderPanel;
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        this.setVisible(false);
    }

    public static class PopupsBorder
    extends LineBorder {
        public PopupsBorder() {
            super(Color.gray);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component c, Insets i) {
            return new Insets(1, 1, 1, 1);
        }
    }
}

