/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.quicklist;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.ui.icon.FileIcons;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.icon.SpinningDial;
import com.mucommander.ui.quicklist.QuickListWithDataList;
import com.mucommander.ui.quicklist.item.DataList;
import com.mucommander.ui.quicklist.item.DataListWithIcons;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QuickListWithIcons<T>
extends QuickListWithDataList<T> {
    private final HashMap<T, Icon> itemToIconCacheMap = new HashMap();
    private static final SpinningDial waitingIcon = new SpinningDial();
    private static final Icon notAvailableIcon = IconManager.getIcon(0, "not_accessible.png");
    private int numOfWaitingIconInList = 0;

    public QuickListWithIcons(String header, String emptyPopupHeader) {
        super(header, emptyPopupHeader);
        this.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                QuickListWithIcons.this.itemToIconCacheMap.clear();
            }
        });
    }

    private synchronized void waitingIconAddedToList() {
        if (this.numOfWaitingIconInList++ == 0) {
            waitingIcon.setAnimated(true);
        }
    }

    private synchronized void waitingIconRemovedFromList() {
        if (--this.numOfWaitingIconInList == 0) {
            waitingIcon.setAnimated(false);
        }
    }

    @Override
    protected DataList<T> getList() {
        return new DataListWithIcons<T>(){

            @Override
            public Icon getImageIconOfItem(T item) {
                return QuickListWithIcons.this.getImageIconOfItemImp(item);
            }
        };
    }

    protected abstract Icon itemToIcon(T var1);

    protected Icon getIconOfFile(AbstractFile file) {
        return file != null && file.exists() ? IconManager.getImageIcon(FileIcons.getFileIcon(file)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getImageIconOfItemImp(final T item) {
        Icon result;
        boolean found;
        HashMap<T, Icon> hashMap = this.itemToIconCacheMap;
        synchronized (hashMap) {
            found = this.itemToIconCacheMap.containsKey(item);
            if (!found) {
                this.itemToIconCacheMap.put(item, waitingIcon);
                this.waitingIconAddedToList();
            }
        }
        if (!found) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Icon icon = QuickListWithIcons.this.itemToIcon(item);
                    HashMap hashMap = QuickListWithIcons.this.itemToIconCacheMap;
                    synchronized (hashMap) {
                        QuickListWithIcons.this.itemToIconCacheMap.put(item, icon != null ? icon : notAvailableIcon);
                    }
                    QuickListWithIcons.this.waitingIconRemovedFromList();
                    QuickListWithIcons.this.repaint();
                }
            }.start();
        }
        HashMap<T, Icon> hashMap2 = this.itemToIconCacheMap;
        synchronized (hashMap2) {
            result = this.itemToIconCacheMap.get(item);
        }
        return result;
    }
}

