/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.quicklist.item;

import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.WindowManager;
import com.mucommander.ui.main.table.CellLabel;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.quicklist.QuickListFocusableComponent;
import com.mucommander.ui.quicklist.QuickListWithDataList;
import com.mucommander.ui.quicksearch.QuickSearch;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeCache;
import com.mucommander.ui.theme.ThemeListener;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataList<T>
extends JList
implements QuickListFocusableComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataList.class);
    private QuickSearch<T> quickSearch = new QuickListQuickSearch();

    public DataList() {
        this.setFocusTraversalKeysEnabled(false);
        this.addMouseListenerToList();
        DataListItemRenderer itemRenderer = this.getItemRenderer();
        ThemeManager.addCurrentThemeListener(itemRenderer);
        this.setCellRenderer(itemRenderer);
    }

    public DataList(T[] data) {
        this();
        this.setListData(data);
    }

    protected DataListItemRenderer getItemRenderer() {
        return new DataListItemRenderer();
    }

    public QuickSearch<T> getQuickSearch() {
        return this.quickSearch;
    }

    public String getItemAsString(T item) {
        return "" + item;
    }

    public void setListData(Object[] data) {
        super.setListData(data);
        int numOfRowsInList = this.getModel().getSize();
        if (numOfRowsInList > 0) {
            this.setVisibleRowCount(Math.min(numOfRowsInList, 10));
            this.setSelectedIndex(0);
            this.ensureIndexIsVisible(0);
        }
    }

    protected T getListItem(int index) {
        if (index > this.getModel().getSize() || index < 0) {
            return null;
        }
        return (T)this.getModel().getElementAt(index);
    }

    protected void addMouseListenerToList() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = DataList.this.locationToIndex(e.getPoint());
                    DataList.this.setSelectedIndex(index);
                    ((QuickListWithDataList)DataList.this.getParent().getParent().getParent()).itemSelected(DataList.this.getSelectedValue());
                }
            }
        });
    }

    public void getFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DataList.this.requestFocus();
            }
        });
    }

    @Override
    public FileTable getInvokerFileTable() {
        return ((QuickListWithDataList)this.getParent().getParent().getParent()).getPanel().getFileTable();
    }

    public void setForegroundColors(Color foreground, Color selectedForeground) {
        DataListItemRenderer cellRenderer = (DataListItemRenderer)this.getCellRenderer();
        cellRenderer.setItemForeground(foreground);
        cellRenderer.setSelectedItemForeground(selectedForeground);
    }

    public void setBackgroundColors(Color background, Color selectedBackground) {
        DataListItemRenderer cellRenderer = (DataListItemRenderer)this.getCellRenderer();
        cellRenderer.setItemBackgound(background);
        cellRenderer.setSelectedItemBackgound(selectedBackground);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class QuickListQuickSearch
    extends QuickSearch<T> {
        public QuickListQuickSearch() {
            super(DataList.this);
        }

        @Override
        protected void searchStarted() {
        }

        @Override
        protected void searchStopped() {
            WindowManager.getCurrentMainFrame().getStatusBar().updateSelectedFilesInfo();
            DataList.this.repaint();
        }

        @Override
        protected int getNumOfItems() {
            return DataList.this.getModel().getSize();
        }

        @Override
        protected String getItemString(int index) {
            return DataList.this.getItemAsString(DataList.this.getListItem(index));
        }

        @Override
        protected void searchStringBecameEmpty(String searchString) {
            WindowManager.getCurrentMainFrame().getStatusBar().setStatusInfo(searchString);
        }

        @Override
        protected void matchFound(int row, String searchString) {
            if (row != DataList.this.getSelectedIndex()) {
                DataList.this.setSelectedIndex(row);
                DataList.this.ensureIndexIsVisible(row);
            }
            WindowManager.getCurrentMainFrame().getStatusBar().setStatusInfo(searchString, IconManager.getIcon(2, "quick_search_ok.png"), false);
        }

        @Override
        protected void matchNotFound(String searchString) {
            WindowManager.getCurrentMainFrame().getStatusBar().setStatusInfo(searchString, IconManager.getIcon(2, "quick_search_ko.png"), false);
        }

        @Override
        public synchronized void keyPressed(KeyEvent e) {
            boolean keyHasModifiers;
            char keyChar = e.getKeyChar();
            if (!this.isActive()) {
                if (!this.isValidQuickSearchInput(e)) {
                    if (keyChar == '\n') {
                        ((QuickListWithDataList)DataList.this.getParent().getParent().getParent()).itemSelected(DataList.this.getSelectedValue());
                    }
                    return;
                }
                this.start();
            }
            int keyCode = e.getKeyCode();
            boolean bl = keyHasModifiers = (e.getModifiersEx() & 0x3C0) != 0;
            if (keyCode == 8 && !keyHasModifiers) {
                if (this.isSearchStringEmpty()) {
                    return;
                }
                this.removeLastCharacterFromSearchString();
                this.findMatch(0, true, true);
            } else if (keyCode == 27 && !keyHasModifiers) {
                this.stop();
            } else if (!(keyCode != 38 && keyCode != 40 || keyHasModifiers)) {
                boolean down = keyCode == 40;
                this.findMatch(DataList.this.getSelectedIndex() + (down ? 1 : -1), down, false);
            } else if (this.isValidQuickSearchInput(e)) {
                this.appendCharacterToSearchString(keyChar);
                this.findMatch(0, true, true);
            } else {
                switch (e.getKeyCode()) {
                    case 10: {
                        ((QuickListWithDataList)DataList.this.getParent().getParent().getParent()).itemSelected(DataList.this.getSelectedValue());
                        this.stop();
                        break;
                    }
                    case 38: {
                        int numOfItems = DataList.this.getModel().getSize();
                        if (numOfItems <= 0 || DataList.this.getSelectedIndex() != 0) break;
                        DataList.this.setSelectedIndex(numOfItems - 1);
                        DataList.this.ensureIndexIsVisible(numOfItems - 1);
                        e.consume();
                        break;
                    }
                    case 40: {
                        int numOfItems = DataList.this.getModel().getSize();
                        if (numOfItems <= 0 || DataList.this.getSelectedIndex() != numOfItems - 1) break;
                        DataList.this.setSelectedIndex(0);
                        DataList.this.ensureIndexIsVisible(0);
                        e.consume();
                        break;
                    }
                    case 9: {
                        DataList.this.getInvokerFileTable().requestFocus();
                        this.stop();
                    }
                }
                return;
            }
            this.setLastSearchStringChange(System.currentTimeMillis());
            e.consume();
        }
    }

    protected class DataListItemRenderer
    extends DefaultListCellRenderer
    implements ThemeListener {
        private Color selectedItemBackgound = ThemeManager.getCurrentColor(66);
        private Color selectedItemForeground = ThemeManager.getCurrentColor(67);
        private Color itemBackgound = ThemeManager.getCurrentColor(64);
        private Color itemForeground = ThemeManager.getCurrentColor(65);
        private Font itemFont = ThemeManager.getCurrentFont(7);

        protected DataListItemRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int rowIndex, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, rowIndex, isSelected, cellHasFocus);
            Object item = DataList.this.getListItem(rowIndex);
            if (item == null) {
                LOGGER.debug("tableModel.getCachedFileAtRow(" + rowIndex + ") RETURNED NULL !");
                return null;
            }
            QuickSearch search = DataList.this.getQuickSearch();
            boolean matches = search.isActive() ? search.matches(DataList.this.getItemAsString(item)) : true;
            CellLabel label = new CellLabel();
            label.setFont(this.itemFont);
            label.setText(DataList.this.getItemAsString(item));
            if (isSelected) {
                label.setBackground(this.selectedItemBackgound);
                label.setForeground(this.selectedItemForeground);
            } else {
                label.setBackground(matches ? this.itemBackgound : ThemeCache.unmatchedBackground);
                label.setForeground(matches ? this.itemForeground : ThemeCache.unmatchedForeground);
            }
            return label;
        }

        public void setSelectedItemBackgound(Color selectedItemBackgound) {
            this.selectedItemBackgound = selectedItemBackgound;
        }

        public void setSelectedItemForeground(Color selectedItemForeground) {
            this.selectedItemForeground = selectedItemForeground;
        }

        public void setItemBackgound(Color itemBackgound) {
            this.itemBackgound = itemBackgound;
        }

        public void setItemForeground(Color itemForeground) {
            this.itemForeground = itemForeground;
        }

        public void colorChanged(ColorChangedEvent event) {
            if (event.getColorId() == 64) {
                this.itemBackgound = ThemeManager.getCurrentColor(64);
            } else if (event.getColorId() == 65) {
                this.itemForeground = ThemeManager.getCurrentColor(65);
            } else if (event.getColorId() == 66) {
                this.selectedItemBackgound = ThemeManager.getCurrentColor(66);
            } else if (event.getColorId() == 67) {
                this.selectedItemForeground = ThemeManager.getCurrentColor(67);
            }
        }

        public void fontChanged(FontChangedEvent event) {
            this.itemFont = ThemeManager.getCurrentFont(7);
        }
    }
}

