/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.quicklist.item;

import com.mucommander.ui.main.table.CellLabel;
import com.mucommander.ui.quicklist.item.DataList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataListWithIcons<T>
extends DataList<T> {
    public DataListWithIcons() {
    }

    public DataListWithIcons(T[] data) {
        super(data);
    }

    @Override
    protected DataList.DataListItemRenderer getItemRenderer() {
        return new DataListItemWithIconRenderer();
    }

    public abstract Icon getImageIconOfItem(T var1);

    protected class DataListItemWithIconRenderer
    extends DataList.DataListItemRenderer {
        protected DataListItemWithIconRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CellLabel label = (CellLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Object item = DataListWithIcons.this.getListItem(index);
            Icon icon = DataListWithIcons.this.getImageIconOfItem(item);
            label.setIcon(this.resizeIcon(icon));
            return label;
        }

        private Icon resizeIcon(Icon icon) {
            if (icon instanceof ImageIcon) {
                Image image = ((ImageIcon)icon).getImage();
                Dimension dimension = this.getPreferredSize();
                double height = dimension.getHeight();
                double width = height / (double)icon.getIconHeight() * (double)icon.getIconWidth();
                image = image.getScaledInstance((int)width, (int)height, 4);
                return new ImageIcon(image);
            }
            return icon;
        }
    }
}

