/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.quicklist.item;

import com.mucommander.ui.quicklist.item.QuickListItem;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class QuickListEmptyMessageItem
extends QuickListItem {
    protected Color foreground = ThemeManager.getCurrentColor(65);
    protected Color background = ThemeManager.getCurrentColor(64);

    public QuickListEmptyMessageItem(String text) {
        super(text);
        this.setFont(ThemeManager.getCurrentFont(7));
    }

    protected final void paintComponent(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(this.background);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setFont(this.FONT);
        graphics.setColor(this.foreground);
        graphics.drawString(this.getText(), 5, (int)graphics.getFontMetrics().getLineMetrics(this.getText(), graphics).getHeight());
    }

    public void colorChanged(ColorChangedEvent event) {
        if (event.getColorId() == 64) {
            this.background = event.getColor();
        } else if (event.getColorId() == 65) {
            this.foreground = event.getColor();
        }
    }

    public void fontChanged(FontChangedEvent event) {
        this.setFont(ThemeManager.getCurrentFont(7));
    }
}

